/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.FFIClosure;
import org.lwjgl.system.libffi.FFIType;

public class LibFFI {
    public static final short FFI_TYPE_LONGDOUBLE;
    public static final int FFI_FIRST_ABI;
    public static final int FFI_WIN64;
    public static final int FFI_GNUW64;
    public static final int FFI_UNIX64;
    public static final int FFI_EFI64;
    public static final int FFI_SYSV;
    public static final int FFI_STDCALL;
    public static final int FFI_THISCALL;
    public static final int FFI_FASTCALL;
    public static final int FFI_MS_CDECL;
    public static final int FFI_PASCAL;
    public static final int FFI_REGISTER;
    public static final int FFI_VFP;
    public static final int FFI_LAST_ABI;
    public static final int FFI_DEFAULT_ABI;
    public static final FFIType ffi_type_void;
    public static final FFIType ffi_type_uint8;
    public static final FFIType ffi_type_sint8;
    public static final FFIType ffi_type_uint16;
    public static final FFIType ffi_type_sint16;
    public static final FFIType ffi_type_uint32;
    public static final FFIType ffi_type_sint32;
    public static final FFIType ffi_type_uint64;
    public static final FFIType ffi_type_sint64;
    public static final FFIType ffi_type_uchar;
    public static final FFIType ffi_type_schar;
    public static final FFIType ffi_type_ushort;
    public static final FFIType ffi_type_sshort;
    public static final FFIType ffi_type_uint;
    public static final FFIType ffi_type_sint;
    public static final FFIType ffi_type_ulong;
    public static final FFIType ffi_type_slong;
    public static final FFIType ffi_type_float;
    public static final FFIType ffi_type_double;
    public static final FFIType ffi_type_longdouble;
    public static final FFIType ffi_type_pointer;

    private static native short FFI_TYPE_DOUBLE();

    private static native int FFI_WIN64();

    private static native int FFI_GNUW64();

    private static native int FFI_UNIX64();

    private static native int FFI_EFI64();

    private static native int FFI_SYSV();

    private static native int FFI_STDCALL();

    private static native int FFI_THISCALL();

    private static native int FFI_FASTCALL();

    private static native int FFI_MS_CDECL();

    private static native int FFI_PASCAL();

    private static native int FFI_REGISTER();

    private static native int FFI_VFP();

    private static native int FFI_FIRST_ABI();

    private static native int FFI_LAST_ABI();

    private static native int FFI_DEFAULT_ABI();

    private static native long nffi_type_void();

    private static FFIType ffi_type_void() {
        long __result = LibFFI.nffi_type_void();
        return FFIType.create(__result);
    }

    private static native long nffi_type_uint8();

    private static FFIType ffi_type_uint8() {
        long __result = LibFFI.nffi_type_uint8();
        return FFIType.create(__result);
    }

    private static native long nffi_type_sint8();

    private static FFIType ffi_type_sint8() {
        long __result = LibFFI.nffi_type_sint8();
        return FFIType.create(__result);
    }

    private static native long nffi_type_uint16();

    private static FFIType ffi_type_uint16() {
        long __result = LibFFI.nffi_type_uint16();
        return FFIType.create(__result);
    }

    private static native long nffi_type_sint16();

    private static FFIType ffi_type_sint16() {
        long __result = LibFFI.nffi_type_sint16();
        return FFIType.create(__result);
    }

    private static native long nffi_type_uint32();

    private static FFIType ffi_type_uint32() {
        long __result = LibFFI.nffi_type_uint32();
        return FFIType.create(__result);
    }

    private static native long nffi_type_sint32();

    private static FFIType ffi_type_sint32() {
        long __result = LibFFI.nffi_type_sint32();
        return FFIType.create(__result);
    }

    private static native long nffi_type_uint64();

    private static FFIType ffi_type_uint64() {
        long __result = LibFFI.nffi_type_uint64();
        return FFIType.create(__result);
    }

    private static native long nffi_type_sint64();

    private static FFIType ffi_type_sint64() {
        long __result = LibFFI.nffi_type_sint64();
        return FFIType.create(__result);
    }

    private static native long nffi_type_uchar();

    private static FFIType ffi_type_uchar() {
        long __result = LibFFI.nffi_type_uchar();
        return FFIType.create(__result);
    }

    private static native long nffi_type_schar();

    private static FFIType ffi_type_schar() {
        long __result = LibFFI.nffi_type_schar();
        return FFIType.create(__result);
    }

    private static native long nffi_type_ushort();

    private static FFIType ffi_type_ushort() {
        long __result = LibFFI.nffi_type_ushort();
        return FFIType.create(__result);
    }

    private static native long nffi_type_sshort();

    private static FFIType ffi_type_sshort() {
        long __result = LibFFI.nffi_type_sshort();
        return FFIType.create(__result);
    }

    private static native long nffi_type_uint();

    private static FFIType ffi_type_uint() {
        long __result = LibFFI.nffi_type_uint();
        return FFIType.create(__result);
    }

    private static native long nffi_type_sint();

    private static FFIType ffi_type_sint() {
        long __result = LibFFI.nffi_type_sint();
        return FFIType.create(__result);
    }

    private static native long nffi_type_ulong();

    private static FFIType ffi_type_ulong() {
        long __result = LibFFI.nffi_type_ulong();
        return FFIType.create(__result);
    }

    private static native long nffi_type_slong();

    private static FFIType ffi_type_slong() {
        long __result = LibFFI.nffi_type_slong();
        return FFIType.create(__result);
    }

    private static native long nffi_type_float();

    private static FFIType ffi_type_float() {
        long __result = LibFFI.nffi_type_float();
        return FFIType.create(__result);
    }

    private static native long nffi_type_double();

    private static FFIType ffi_type_double() {
        long __result = LibFFI.nffi_type_double();
        return FFIType.create(__result);
    }

    private static native long nffi_type_longdouble();

    private static FFIType ffi_type_longdouble() {
        long __result = LibFFI.nffi_type_longdouble();
        return FFIType.create(__result);
    }

    private static native long nffi_type_pointer();

    private static FFIType ffi_type_pointer() {
        long __result = LibFFI.nffi_type_pointer();
        return FFIType.create(__result);
    }

    public static native int nffi_prep_cif(long var0, int var2, int var3, long var4, long var6);

    public static int ffi_prep_cif(FFICIF cif, int abi, FFIType rtype, @Nullable PointerBuffer atypes) {
        return LibFFI.nffi_prep_cif(cif.address(), abi, Checks.remainingSafe(atypes), rtype.address(), MemoryUtil.memAddressSafe(atypes));
    }

    public static native long nffi_closure_alloc(long var0, long var2);

    @Nullable
    public static FFIClosure ffi_closure_alloc(long size, PointerBuffer code) {
        if (Checks.CHECKS) {
            Checks.check(code, 1);
        }
        long __result = LibFFI.nffi_closure_alloc(size, MemoryUtil.memAddress(code));
        return FFIClosure.createSafe(__result);
    }

    public static native void nffi_closure_free(long var0);

    public static void ffi_closure_free(FFIClosure writable) {
        LibFFI.nffi_closure_free(writable.address());
    }

    public static native int nffi_prep_closure_loc(long var0, long var2, long var4, long var6, long var8);

    public static int ffi_prep_closure_loc(FFIClosure closure, FFICIF cif, long fun, long user_data, long codeloc) {
        if (Checks.CHECKS) {
            Checks.check(fun);
            Checks.check(codeloc);
        }
        return LibFFI.nffi_prep_closure_loc(closure.address(), cif.address(), fun, user_data, codeloc);
    }

    static {
        Library.initialize();
        FFI_TYPE_LONGDOUBLE = LibFFI.FFI_TYPE_DOUBLE();
        FFI_FIRST_ABI = LibFFI.FFI_FIRST_ABI();
        FFI_WIN64 = LibFFI.FFI_WIN64();
        FFI_GNUW64 = LibFFI.FFI_GNUW64();
        FFI_UNIX64 = LibFFI.FFI_UNIX64();
        FFI_EFI64 = LibFFI.FFI_EFI64();
        FFI_SYSV = LibFFI.FFI_SYSV();
        FFI_STDCALL = LibFFI.FFI_STDCALL();
        FFI_THISCALL = LibFFI.FFI_THISCALL();
        FFI_FASTCALL = LibFFI.FFI_FASTCALL();
        FFI_MS_CDECL = LibFFI.FFI_MS_CDECL();
        FFI_PASCAL = LibFFI.FFI_PASCAL();
        FFI_REGISTER = LibFFI.FFI_REGISTER();
        FFI_VFP = LibFFI.FFI_VFP();
        FFI_LAST_ABI = LibFFI.FFI_LAST_ABI();
        FFI_DEFAULT_ABI = LibFFI.FFI_DEFAULT_ABI();
        ffi_type_void = LibFFI.ffi_type_void();
        ffi_type_uint8 = LibFFI.ffi_type_uint8();
        ffi_type_sint8 = LibFFI.ffi_type_sint8();
        ffi_type_uint16 = LibFFI.ffi_type_uint16();
        ffi_type_sint16 = LibFFI.ffi_type_sint16();
        ffi_type_uint32 = LibFFI.ffi_type_uint32();
        ffi_type_sint32 = LibFFI.ffi_type_sint32();
        ffi_type_uint64 = LibFFI.ffi_type_uint64();
        ffi_type_sint64 = LibFFI.ffi_type_sint64();
        ffi_type_uchar = LibFFI.ffi_type_uchar();
        ffi_type_schar = LibFFI.ffi_type_schar();
        ffi_type_ushort = LibFFI.ffi_type_ushort();
        ffi_type_sshort = LibFFI.ffi_type_sshort();
        ffi_type_uint = LibFFI.ffi_type_uint();
        ffi_type_sint = LibFFI.ffi_type_sint();
        ffi_type_ulong = LibFFI.ffi_type_ulong();
        ffi_type_slong = LibFFI.ffi_type_slong();
        ffi_type_float = LibFFI.ffi_type_float();
        ffi_type_double = LibFFI.ffi_type_double();
        ffi_type_longdouble = LibFFI.ffi_type_longdouble();
        ffi_type_pointer = LibFFI.ffi_type_pointer();
    }
}

