/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.LibSTB;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class STBVorbis {
    public static native int nstb_vorbis_decode_memory(long var0, int var2, long var3, long var5, long var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ShortBuffer stb_vorbis_decode_memory(ByteBuffer mem, IntBuffer channels, IntBuffer sample_rate) {
        if (Checks.CHECKS) {
            Checks.check(channels, 1);
            Checks.check(sample_rate, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer output = stack.pointers(0L);
            int __result = STBVorbis.nstb_vorbis_decode_memory(MemoryUtil.memAddress(mem), mem.remaining(), MemoryUtil.memAddress(channels), MemoryUtil.memAddress(sample_rate), MemoryUtil.memAddress(output));
            ShortBuffer shortBuffer = MemoryUtil.memShortBufferSafe(output.get(0), __result * channels.get(0));
            return shortBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static {
        LibSTB.initialize();
    }
}

