/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.BonePose;
import com.esotericsoftware.spine.Constraint;
import com.esotericsoftware.spine.Physics;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.TransformConstraintPose;

public class TransformConstraint
extends Constraint<TransformConstraint, TransformConstraintData, TransformConstraintPose> {
    final Array<BonePose> bones;
    Bone source;

    public TransformConstraint(TransformConstraintData transformConstraintData, Skeleton skeleton) {
        super(transformConstraintData, new TransformConstraintPose(), new TransformConstraintPose());
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.bones = new Array(true, transformConstraintData.bones.size, BonePose[]::new);
        for (BoneData boneData : transformConstraintData.bones) {
            this.bones.add((BonePose)((Bone[])skeleton.bones.items)[boneData.index].constrained);
        }
        this.source = ((Bone[])skeleton.bones.items)[transformConstraintData.source.index];
    }

    @Override
    public void update(Skeleton skeleton, Physics physics) {
        TransformConstraintPose transformConstraintPose = (TransformConstraintPose)this.applied;
        if (transformConstraintPose.mixRotate == 0.0f & transformConstraintPose.mixX == 0.0f & transformConstraintPose.mixY == 0.0f & transformConstraintPose.mixScaleX == 0.0f & transformConstraintPose.mixScaleY == 0.0f & transformConstraintPose.mixShearY == 0.0f) {
            return;
        }
        TransformConstraintData transformConstraintData = (TransformConstraintData)this.data;
        boolean bl = transformConstraintData.localSource;
        boolean bl2 = transformConstraintData.localTarget;
        boolean bl3 = transformConstraintData.additive;
        boolean bl4 = transformConstraintData.clamp;
        float[] fArray = transformConstraintData.offsets;
        BonePose bonePose = (BonePose)this.source.applied;
        if (bl) {
            bonePose.validateLocalTransform(skeleton);
        }
        TransformConstraintData.FromProperty[] fromPropertyArray = (TransformConstraintData.FromProperty[])transformConstraintData.properties.items;
        int n = transformConstraintData.properties.size;
        int n2 = skeleton.update;
        BonePose[] bonePoseArray = (BonePose[])this.bones.items;
        int n3 = this.bones.size;
        for (int i = 0; i < n3; ++i) {
            BonePose bonePose2 = bonePoseArray[i];
            if (bl2) {
                bonePose2.modifyLocal(skeleton);
            } else {
                bonePose2.modifyWorld(n2);
            }
            for (int j = 0; j < n; ++j) {
                TransformConstraintData.FromProperty fromProperty = fromPropertyArray[j];
                float f = fromProperty.value(skeleton, bonePose, bl, fArray) - fromProperty.offset;
                TransformConstraintData.ToProperty[] toPropertyArray = (TransformConstraintData.ToProperty[])fromProperty.to.items;
                int n4 = fromProperty.to.size;
                for (int k = 0; k < n4; ++k) {
                    TransformConstraintData.ToProperty toProperty = toPropertyArray[k];
                    if (toProperty.mix(transformConstraintPose) == 0.0f) continue;
                    float f2 = toProperty.offset + f * toProperty.scale;
                    if (bl4) {
                        f2 = toProperty.offset < toProperty.max ? MathUtils.clamp(f2, toProperty.offset, toProperty.max) : MathUtils.clamp(f2, toProperty.max, toProperty.offset);
                    }
                    toProperty.apply(skeleton, transformConstraintPose, bonePose2, f2, bl2, bl3);
                }
            }
        }
    }

    @Override
    void sort(Skeleton skeleton) {
        int n;
        boolean bl;
        if (!((TransformConstraintData)this.data).localSource) {
            skeleton.sortBone(this.source);
        }
        BonePose[] bonePoseArray = (BonePose[])this.bones.items;
        int n2 = this.bones.size;
        boolean bl2 = bl = !((TransformConstraintData)this.data).localTarget;
        if (bl) {
            for (n = 0; n < n2; ++n) {
                skeleton.sortBone(bonePoseArray[n].bone);
            }
        }
        skeleton.updateCache.add(this);
        for (n = 0; n < n2; ++n) {
            Bone bone = bonePoseArray[n].bone;
            skeleton.sortReset(bone.children);
            skeleton.constrained(bone);
        }
        for (n = 0; n < n2; ++n) {
            bonePoseArray[n].bone.sorted = bl;
        }
    }

    @Override
    boolean isSourceActive() {
        return this.source.active;
    }
}

