/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Posed;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.SlotPose;

public class Slot
extends Posed<SlotData, SlotPose, SlotPose> {
    final Skeleton skeleton;
    final Bone bone;
    int attachmentState;

    public Slot(SlotData slotData, Skeleton skeleton) {
        super(slotData, new SlotPose(), new SlotPose());
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.skeleton = skeleton;
        this.bone = ((Bone[])skeleton.bones.items)[slotData.boneData.index];
        if (((SlotPose)slotData.setup).darkColor != null) {
            ((SlotPose)this.pose).darkColor = new Color();
            ((SlotPose)this.constrained).darkColor = new Color();
        }
        this.setupPose();
    }

    public Bone getBone() {
        return this.bone;
    }

    @Override
    public void setupPose() {
        ((SlotPose)this.pose).color.set(((SlotPose)((SlotData)this.data).setup).color);
        if (((SlotPose)this.pose).darkColor != null) {
            ((SlotPose)this.pose).darkColor.set(((SlotPose)((SlotData)this.data).setup).darkColor);
        }
        ((SlotPose)this.pose).sequenceIndex = ((SlotPose)((SlotData)this.data).setup).sequenceIndex;
        if (((SlotData)this.data).attachmentName == null) {
            ((SlotPose)this.pose).setAttachment(null);
        } else {
            ((SlotPose)this.pose).attachment = null;
            ((SlotPose)this.pose).setAttachment(this.skeleton.getAttachment(((SlotData)this.data).index, ((SlotData)this.data).attachmentName));
        }
    }
}

