/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.OrderedSet;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.SlotPose;
import com.esotericsoftware.spine.attachments.Attachment;

public class Skin {
    final String name;
    final OrderedSet<SkinEntry> attachments = new OrderedSet();
    final Array<BoneData> bones = new Array(true, 0, BoneData[]::new);
    final Array<ConstraintData> constraints = new Array(true, 0, ConstraintData[]::new);
    private final SkinEntry lookup = new SkinEntry(0, "", null);
    final Color color = new Color(0.99607843f, 0.61960787f, 0.30980393f, 1.0f);

    public Skin(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        this.name = string;
        this.attachments.orderedItems().ordered = false;
    }

    public void setAttachment(int n, String string, Attachment attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("attachment cannot be null.");
        }
        SkinEntry skinEntry = new SkinEntry(n, string, attachment);
        if (!this.attachments.add(skinEntry)) {
            this.attachments.get((SkinEntry)skinEntry).attachment = attachment;
        }
    }

    public Attachment getAttachment(int n, String string) {
        this.lookup.set(n, string);
        SkinEntry skinEntry = this.attachments.get(this.lookup);
        return skinEntry != null ? skinEntry.attachment : null;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return this.name;
    }

    void attachAll(Skeleton skeleton, Skin skin) {
        Slot[] slotArray = (Slot[])skeleton.slots.items;
        for (SkinEntry skinEntry : skin.attachments.orderedItems()) {
            Attachment attachment;
            SlotPose slotPose = (SlotPose)slotArray[skinEntry.slotIndex].pose;
            if (slotPose.attachment != skinEntry.attachment || (attachment = this.getAttachment(skinEntry.slotIndex, skinEntry.name)) == null) continue;
            slotPose.setAttachment(attachment);
        }
    }

    public static class SkinEntry {
        int slotIndex;
        String name;
        Attachment attachment;
        private int hashCode;

        SkinEntry(int n, String string, Attachment attachment) {
            this.set(n, string);
            this.attachment = attachment;
        }

        void set(int n, String string) {
            if (n < 0) {
                throw new IllegalArgumentException("slotIndex must be >= 0.");
            }
            if (string == null) {
                throw new IllegalArgumentException("name cannot be null.");
            }
            this.slotIndex = n;
            this.name = string;
            this.hashCode = string.hashCode() + n * 37;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            SkinEntry skinEntry = (SkinEntry)object;
            if (this.slotIndex != skinEntry.slotIndex) {
                return false;
            }
            return this.name.equals(skinEntry.name);
        }

        public String toString() {
            return this.slotIndex + ":" + this.name;
        }
    }
}

