/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.badlogic.gdx.utils.ShortArray;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.SlotPose;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.SkeletonAttachment;
import com.esotericsoftware.spine.utils.SkeletonClipping;
import com.esotericsoftware.spine.utils.TwoColorPolygonBatch;

public class SkeletonRenderer {
    private static final short[] quadTriangles = new short[]{0, 1, 2, 2, 3, 0};
    private boolean pmaColors;
    private boolean pmaBlendModes;
    private final FloatArray vertices = new FloatArray(32);
    private final SkeletonClipping clipper = new SkeletonClipping();

    public void draw(TwoColorPolygonBatch twoColorPolygonBatch, Skeleton skeleton) {
        if (twoColorPolygonBatch == null) {
            throw new IllegalArgumentException("batch cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        boolean bl = this.pmaColors;
        boolean bl2 = this.pmaBlendModes;
        twoColorPolygonBatch.setPremultipliedAlpha(bl);
        Object object = null;
        int n = 0;
        float[] fArray = null;
        float[] fArray2 = null;
        short[] sArray = null;
        Color color = null;
        Color color2 = skeleton.color;
        float f = color2.r;
        float f2 = color2.g;
        float f3 = color2.b;
        float f4 = color2.a;
        Slot[] slotArray = (Slot[])skeleton.drawOrder.items;
        int n2 = skeleton.drawOrder.size;
        for (int i = 0; i < n2; ++i) {
            Slot slot = slotArray[i];
            if (slot.bone.active) {
                SlotPose slotPose = (SlotPose)slot.applied;
                Attachment attachment = slotPose.attachment;
                if (attachment != null) {
                    Object object2;
                    Object object3;
                    Texture texture = null;
                    if (attachment instanceof RegionAttachment) {
                        object3 = (RegionAttachment)attachment;
                        n = 24;
                        fArray = this.vertices.items;
                        ((RegionAttachment)object3).computeWorldVertices(slot, fArray, 0, 6);
                        sArray = quadTriangles;
                        texture = ((RegionAttachment)object3).getRegion().getTexture();
                        fArray2 = ((RegionAttachment)object3).getUVs();
                        color = ((RegionAttachment)object3).getColor();
                    } else if (attachment instanceof MeshAttachment) {
                        MeshAttachment meshAttachment = (MeshAttachment)attachment;
                        int n3 = meshAttachment.getWorldVerticesLength();
                        n = n3 * 3;
                        fArray = this.vertices.setSize(n);
                        meshAttachment.computeWorldVertices(skeleton, slot, 0, n3, fArray, 0, 6);
                        sArray = meshAttachment.getTriangles();
                        texture = meshAttachment.getRegion().getTexture();
                        fArray2 = meshAttachment.getUVs();
                        color = meshAttachment.getColor();
                    } else {
                        Skeleton skeleton2;
                        if (attachment instanceof ClippingAttachment) {
                            ClippingAttachment clippingAttachment = (ClippingAttachment)attachment;
                            this.clipper.clipEnd(slot);
                            this.clipper.clipStart(skeleton, slot, clippingAttachment);
                            continue;
                        }
                        if (attachment instanceof SkeletonAttachment && (skeleton2 = (object2 = (SkeletonAttachment)attachment).getSkeleton()) != null) {
                            this.draw(twoColorPolygonBatch, skeleton2);
                        }
                    }
                    if (texture != null) {
                        float f5;
                        object3 = slotPose.getColor();
                        float f6 = f4 * ((Color)object3).a * color.a * 255.0f;
                        float f7 = bl ? f6 : 255.0f;
                        object2 = ((SlotData)slot.data).getBlendMode();
                        if (object2 != object) {
                            if (object2 == BlendMode.additive && bl) {
                                object2 = BlendMode.normal;
                                f6 = 0.0f;
                            }
                            object = object2;
                            ((BlendMode)((Object)object)).apply(twoColorPolygonBatch, bl2);
                        }
                        float f8 = f * color.r * f7;
                        float f9 = f2 * color.g * f7;
                        float f10 = f3 * color.b * f7;
                        float f11 = NumberUtils.intToFloatColor((int)f6 << 24 | (int)(f10 * ((Color)object3).b) << 16 | (int)(f9 * ((Color)object3).g) << 8 | (int)(f8 * ((Color)object3).r));
                        Color color3 = slotPose.getDarkColor();
                        float f12 = f5 = color3 == null ? 0.0f : NumberUtils.intToFloatColor((int)(f10 * color3.b) << 16 | (int)(f9 * color3.g) << 8 | (int)(f8 * color3.r));
                        if (this.clipper.isClipping() && this.clipper.clipTriangles(fArray, sArray, sArray.length, fArray2, f11, f5, true, 6)) {
                            FloatArray floatArray = this.clipper.getClippedVertices();
                            ShortArray shortArray = this.clipper.getClippedTriangles();
                            twoColorPolygonBatch.drawTwoColor(texture, floatArray.items, 0, floatArray.size, shortArray.items, 0, shortArray.size);
                        } else {
                            int n4 = 2;
                            int n5 = 0;
                            while (n4 < n) {
                                fArray[n4] = f11;
                                fArray[n4 + 1] = f5;
                                fArray[n4 + 2] = fArray2[n5];
                                fArray[n4 + 3] = fArray2[n5 + 1];
                                n4 += 6;
                                n5 += 2;
                            }
                            twoColorPolygonBatch.drawTwoColor(texture, fArray, 0, n, sArray, 0, sArray.length);
                        }
                    }
                }
            }
            this.clipper.clipEnd(slot);
        }
        this.clipper.clipEnd();
    }

    public void setPremultipliedAlpha(boolean bl) {
        this.pmaColors = bl;
        this.pmaBlendModes = bl;
    }
}

