/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Texture;

public class TextureRegion {
    Texture texture;
    float u;
    float v;
    float u2;
    float v2;
    int regionWidth;
    int regionHeight;

    public TextureRegion() {
    }

    public TextureRegion(Texture texture) {
        if (texture == null) {
            throw new IllegalArgumentException("texture cannot be null.");
        }
        this.texture = texture;
        this.setRegion(0, 0, texture.getWidth(), texture.getHeight());
    }

    public TextureRegion(Texture texture, int x, int y, int width, int height) {
        this.texture = texture;
        this.setRegion(x, y, width, height);
    }

    public TextureRegion(TextureRegion region, int x, int y, int width, int height) {
        this.setRegion(region, x, y, width, height);
    }

    public void setRegion(int x, int y, int width, int height) {
        float invTexWidth = 1.0f / (float)this.texture.getWidth();
        float invTexHeight = 1.0f / (float)this.texture.getHeight();
        this.setRegion((float)x * invTexWidth, (float)y * invTexHeight, (float)(x + width) * invTexWidth, (float)(y + height) * invTexHeight);
        this.regionWidth = Math.abs(width);
        this.regionHeight = Math.abs(height);
    }

    public void setRegion(float u, float v, float u2, float v2) {
        int texWidth = this.texture.getWidth();
        int texHeight = this.texture.getHeight();
        this.regionWidth = Math.round(Math.abs(u2 - u) * (float)texWidth);
        this.regionHeight = Math.round(Math.abs(v2 - v) * (float)texHeight);
        if (this.regionWidth == 1 && this.regionHeight == 1) {
            float adjustX = 0.25f / (float)texWidth;
            u += adjustX;
            u2 -= adjustX;
            float adjustY = 0.25f / (float)texHeight;
            v += adjustY;
            v2 -= adjustY;
        }
        this.u = u;
        this.v = v;
        this.u2 = u2;
        this.v2 = v2;
    }

    public void setRegion(TextureRegion region) {
        this.texture = region.texture;
        this.setRegion(region.u, region.v, region.u2, region.v2);
    }

    public void setRegion(TextureRegion region, int x, int y, int width, int height) {
        this.texture = region.texture;
        this.setRegion(region.getRegionX() + x, region.getRegionY() + y, width, height);
    }

    public Texture getTexture() {
        return this.texture;
    }

    public float getU() {
        return this.u;
    }

    public float getV() {
        return this.v;
    }

    public float getU2() {
        return this.u2;
    }

    public float getV2() {
        return this.v2;
    }

    public int getRegionX() {
        return Math.round(this.u * (float)this.texture.getWidth());
    }

    public int getRegionY() {
        return Math.round(this.v * (float)this.texture.getHeight());
    }

    public int getRegionWidth() {
        return this.regionWidth;
    }

    public int getRegionHeight() {
        return this.regionHeight;
    }

    public void flip(boolean x, boolean y) {
        float temp;
        if (x) {
            temp = this.u;
            this.u = this.u2;
            this.u2 = temp;
        }
        if (y) {
            temp = this.v;
            this.v = this.v2;
            this.v2 = temp;
        }
    }
}

