/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.LongPredicate;
import javax.annotation.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.Library;
import org.lwjgl.system.MathUtil;
import org.lwjgl.system.MemoryManage;
import org.lwjgl.system.MultiReleaseMemCopy;
import org.lwjgl.system.MultiReleaseTextDecoding;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.jni.JNINativeInterface;
import org.lwjgl.system.libc.LibCString;
import sun.misc.Unsafe;

public final class MemoryUtil {
    public static final int PAGE_SIZE;
    public static final int CACHE_LINE_SIZE;
    static final int ARRAY_TLC_SIZE;
    static final ThreadLocal<byte[]> ARRAY_TLC_BYTE;
    static final ThreadLocal<char[]> ARRAY_TLC_CHAR;
    static final Unsafe UNSAFE;
    static final ByteOrder NATIVE_ORDER;
    private static final Charset UTF16;
    static final Class<? extends ByteBuffer> BUFFER_BYTE;
    static final Class<? extends ShortBuffer> BUFFER_SHORT;
    static final Class<? extends CharBuffer> BUFFER_CHAR;
    static final Class<? extends IntBuffer> BUFFER_INT;
    static final Class<? extends LongBuffer> BUFFER_LONG;
    static final Class<? extends FloatBuffer> BUFFER_FLOAT;
    static final Class<? extends DoubleBuffer> BUFFER_DOUBLE;
    private static final long MARK;
    private static final long POSITION;
    private static final long LIMIT;
    private static final long CAPACITY;
    private static final long ADDRESS;
    private static final long PARENT_BYTE;
    private static final long PARENT_SHORT;
    private static final long PARENT_CHAR;
    private static final long PARENT_INT;
    private static final long PARENT_LONG;
    private static final long PARENT_FLOAT;
    private static final long PARENT_DOUBLE;
    private static final int FILL_PATTERN_32;
    private static final long FILL_PATTERN_64;

    public static MemoryAllocator getAllocator() {
        return MemoryUtil.getAllocator(false);
    }

    public static MemoryAllocator getAllocator(boolean tracked) {
        return tracked ? LazyInit.ALLOCATOR : LazyInit.ALLOCATOR_IMPL;
    }

    public static long nmemAlloc(long size) {
        return LazyInit.ALLOCATOR.malloc(size);
    }

    public static long nmemAllocChecked(long size) {
        long address = MemoryUtil.nmemAlloc(size != 0L ? size : 1L);
        if (Checks.CHECKS && address == 0L) {
            throw new OutOfMemoryError();
        }
        return address;
    }

    public static ByteBuffer memAlloc(int size) {
        return MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.nmemAllocChecked(size), size).order(NATIVE_ORDER);
    }

    public static void nmemFree(long ptr) {
        LazyInit.ALLOCATOR.free(ptr);
    }

    public static void memFree(@Nullable Buffer ptr) {
        if (ptr != null) {
            MemoryUtil.nmemFree(UNSAFE.getLong(ptr, ADDRESS));
        }
    }

    public static long nmemRealloc(long ptr, long size) {
        return LazyInit.ALLOCATOR.realloc(ptr, size);
    }

    public static long nmemReallocChecked(long ptr, long size) {
        long address = MemoryUtil.nmemRealloc(ptr, size != 0L ? size : 1L);
        if (Checks.CHECKS && address == 0L) {
            throw new OutOfMemoryError();
        }
        return address;
    }

    private static <T extends Buffer> T realloc(@Nullable T old_p, T new_p, int size) {
        if (old_p != null) {
            new_p.position(Math.min(old_p.position(), size));
        }
        return new_p;
    }

    public static ByteBuffer memRealloc(@Nullable ByteBuffer ptr, int size) {
        return MemoryUtil.realloc(ptr, MemoryUtil.memByteBuffer(MemoryUtil.nmemReallocChecked(ptr == null ? 0L : UNSAFE.getLong(ptr, ADDRESS), size), size), size);
    }

    public static long memAddress0(Buffer buffer) {
        return UNSAFE.getLong(buffer, ADDRESS);
    }

    public static long memAddress(ByteBuffer buffer) {
        return (long)buffer.position() + MemoryUtil.memAddress0(buffer);
    }

    private static long address(int position, int elementShift, long address) {
        return address + (((long)position & 0xFFFFFFFFL) << elementShift);
    }

    public static long memAddress(ShortBuffer buffer) {
        return MemoryUtil.address(buffer.position(), 1, MemoryUtil.memAddress0(buffer));
    }

    public static long memAddress(IntBuffer buffer) {
        return MemoryUtil.address(buffer.position(), 2, MemoryUtil.memAddress0(buffer));
    }

    public static long memAddress(FloatBuffer buffer) {
        return MemoryUtil.address(buffer.position(), 2, MemoryUtil.memAddress0(buffer));
    }

    public static long memAddress(DoubleBuffer buffer) {
        return MemoryUtil.address(buffer.position(), 3, MemoryUtil.memAddress0(buffer));
    }

    public static long memAddress(CustomBuffer<?> buffer) {
        return buffer.address();
    }

    public static long memAddressSafe(@Nullable ByteBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress0(buffer) + (long)buffer.position();
    }

    public static long memAddressSafe(@Nullable ShortBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.address(buffer.position(), 1, MemoryUtil.memAddress0(buffer));
    }

    public static long memAddressSafe(@Nullable IntBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.address(buffer.position(), 2, MemoryUtil.memAddress0(buffer));
    }

    public static long memAddressSafe(@Nullable FloatBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.address(buffer.position(), 2, MemoryUtil.memAddress0(buffer));
    }

    public static long memAddressSafe(@Nullable DoubleBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.address(buffer.position(), 3, MemoryUtil.memAddress0(buffer));
    }

    public static long memAddressSafe(@Nullable Pointer pointer) {
        return pointer == null ? 0L : pointer.address();
    }

    public static ByteBuffer memByteBuffer(long address, int capacity) {
        if (Checks.CHECKS) {
            Checks.check(address);
        }
        return MemoryUtil.wrap(BUFFER_BYTE, address, capacity).order(NATIVE_ORDER);
    }

    public static CharBuffer memCharBuffer(long address, int capacity) {
        if (Checks.CHECKS) {
            Checks.check(address);
        }
        return MemoryUtil.wrap(BUFFER_CHAR, address, capacity);
    }

    public static void memSet(long ptr, int value, long bytes) {
        if (Checks.DEBUG && (ptr == 0L || bytes < 0L)) {
            throw new IllegalArgumentException();
        }
        if (bytes < 256L) {
            int p = (int)ptr;
            if (Pointer.BITS64) {
                if ((p & 7) == 0) {
                    MemoryUtil.memSet64(ptr, value, (int)bytes & 0xFF);
                    return;
                }
            } else if ((p & 3) == 0) {
                MemoryUtil.memSet32(p, value, (int)bytes & 0xFF);
                return;
            }
        }
        LibCString.nmemset(ptr, value, bytes);
    }

    private static void memSet64(long ptr, int value, int bytes) {
        int aligned = bytes & 0xFFFFFFF8;
        long valuel = (long)(value & 0xFF) * FILL_PATTERN_64;
        for (int i = 0; i < aligned; i += 8) {
            UNSAFE.putLong(null, ptr + (long)i, valuel);
        }
        byte valueb = (byte)(value & 0xFF);
        for (int i = aligned; i < bytes; ++i) {
            UNSAFE.putByte(null, ptr + (long)i, valueb);
        }
    }

    private static void memSet32(int ptr, int value, int bytes) {
        int aligned = bytes & 0xFFFFFFFC;
        int vi = (value & 0xFF) * FILL_PATTERN_32;
        for (int i = 0; i < aligned; i += 4) {
            UNSAFE.putInt(null, (long)(ptr + i) & 0xFFFFFFFFL, vi);
        }
        byte vb = (byte)(value & 0xFF);
        for (int i = aligned; i < bytes; ++i) {
            UNSAFE.putByte(null, (long)(ptr + i) & 0xFFFFFFFFL, vb);
        }
    }

    public static void memCopy(long src, long dst, long bytes) {
        if (Checks.DEBUG && (src == 0L || dst == 0L || bytes < 0L)) {
            throw new IllegalArgumentException();
        }
        MultiReleaseMemCopy.copy(src, dst, bytes);
    }

    static void memCopyAligned64(long src, long dst, int bytes) {
        int i;
        int aligned = bytes & 0xFFFFFFF8;
        for (i = 0; i < aligned; i += 8) {
            UNSAFE.putLong(null, dst + (long)i, UNSAFE.getLong(null, src + (long)i));
        }
        for (i = aligned; i < bytes; ++i) {
            UNSAFE.putByte(null, dst + (long)i, UNSAFE.getByte(null, src + (long)i));
        }
    }

    public static byte memGetByte(long ptr) {
        return UNSAFE.getByte(null, ptr);
    }

    public static int memGetInt(long ptr) {
        return UNSAFE.getInt(null, ptr);
    }

    public static float memGetFloat(long ptr) {
        return UNSAFE.getFloat(null, ptr);
    }

    public static double memGetDouble(long ptr) {
        return UNSAFE.getDouble(null, ptr);
    }

    public static long memGetAddress(long ptr) {
        return Pointer.BITS64 ? UNSAFE.getLong(null, ptr) : (long)UNSAFE.getInt(null, ptr) & 0xFFFFFFFFL;
    }

    public static void memPutAddress(long ptr, long value) {
        if (Pointer.BITS64) {
            UNSAFE.putLong(null, ptr, value);
        } else {
            UNSAFE.putInt(null, ptr, (int)value);
        }
    }

    public static native <T> T memGlobalRefToObject(long var0);

    private static int write8(long target, int offset, int value) {
        UNSAFE.putByte(null, target + Integer.toUnsignedLong(offset), (byte)value);
        return offset + 1;
    }

    private static int write16(long target, int offset, char value) {
        UNSAFE.putShort(null, target + Integer.toUnsignedLong(offset), (short)value);
        return offset + 2;
    }

    static int encodeASCIIUnsafe(CharSequence text, boolean nullTerminated, long target) {
        int i = 0;
        int len = text.length();
        while (i < len) {
            i = MemoryUtil.write8(target, i, text.charAt(i));
        }
        if (nullTerminated) {
            i = MemoryUtil.write8(target, i, 0);
        }
        return i;
    }

    public static int memLengthASCII(CharSequence value, boolean nullTerminated) {
        int len = value.length() + (nullTerminated ? 1 : 0);
        if (len < 0) {
            throw new BufferOverflowException();
        }
        return len;
    }

    public static ByteBuffer memUTF8(CharSequence text, boolean nullTerminated) {
        int length = MemoryUtil.memLengthUTF8(text, nullTerminated);
        long target = MemoryUtil.nmemAlloc(length);
        if (Checks.CHECKS && target == 0L) {
            throw new OutOfMemoryError();
        }
        MemoryUtil.encodeUTF8Unsafe(text, nullTerminated, target);
        return MemoryUtil.wrap(BUFFER_BYTE, target, length).order(NATIVE_ORDER);
    }

    static int encodeUTF8Unsafe(CharSequence text, boolean nullTerminated, long target) {
        int p = 0;
        int i = 0;
        int len = text.length();
        while (i < len) {
            int c;
            if ((c = text.charAt(i++)) < 128) {
                p = MemoryUtil.write8(target, p, c);
                continue;
            }
            int cp = c;
            if (c < 2048) {
                p = MemoryUtil.write8(target, p, 0xC0 | cp >> 6);
            } else {
                if (!Character.isHighSurrogate((char)c)) {
                    p = MemoryUtil.write8(target, p, 0xE0 | cp >> 12);
                } else {
                    cp = Character.toCodePoint((char)c, text.charAt(i++));
                    p = MemoryUtil.write8(target, p, 0xF0 | cp >> 18);
                    p = MemoryUtil.write8(target, p, 0x80 | cp >> 12 & 0x3F);
                }
                p = MemoryUtil.write8(target, p, 0x80 | cp >> 6 & 0x3F);
            }
            p = MemoryUtil.write8(target, p, 0x80 | cp & 0x3F);
        }
        if (nullTerminated) {
            p = MemoryUtil.write8(target, p, 0);
        }
        return p;
    }

    public static int memLengthUTF8(CharSequence value, boolean nullTerminated) {
        int len = value.length();
        int bytes = len + (nullTerminated ? 1 : 0);
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c < '\u0080') continue;
            if (c < '\u0800') {
                bytes += 127 - c >>> 31;
            } else {
                bytes += 2;
                if (Character.isHighSurrogate(c)) {
                    ++i;
                }
            }
            if (bytes >= 0) continue;
            throw new BufferOverflowException();
        }
        if (bytes < 0) {
            throw new BufferOverflowException();
        }
        return bytes;
    }

    static int encodeUTF16Unsafe(CharSequence text, boolean nullTerminated, long target) {
        int p = 0;
        int i = 0;
        int len = text.length();
        while (i < len) {
            p = MemoryUtil.write16(target, p, text.charAt(i++));
        }
        if (nullTerminated) {
            p = MemoryUtil.write16(target, p, '\u0000');
        }
        return p;
    }

    public static int memLengthUTF16(CharSequence value, boolean nullTerminated) {
        int len = value.length() + (nullTerminated ? 1 : 0);
        if (len < 0 || 0x3FFFFFFF < len) {
            throw new BufferOverflowException();
        }
        return len << 1;
    }

    private static int memLengthNT1(long address, int maxLength) {
        if (Checks.CHECKS) {
            Checks.check(address);
        }
        return Pointer.BITS64 ? MemoryUtil.strlen64NT1(address, maxLength) : MemoryUtil.strlen32NT1(address, maxLength);
    }

    private static int strlen64NT1(long address, int maxLength) {
        int i;
        if (8 <= maxLength) {
            int misalignment = (int)address & 7;
            if (misalignment != 0) {
                int len = 8 - misalignment;
                for (i = 0; i < len; ++i) {
                    if (UNSAFE.getByte(null, address + (long)i) != 0) continue;
                    return i;
                }
            }
            while (i <= maxLength - 8 && !MathUtil.mathHasZeroByte(UNSAFE.getLong(null, address + (long)i))) {
                i += 8;
            }
        }
        while (i < maxLength && UNSAFE.getByte(null, address + (long)i) != 0) {
            ++i;
        }
        return i;
    }

    private static int strlen32NT1(long address, int maxLength) {
        int i;
        if (4 <= maxLength) {
            int misalignment = (int)address & 3;
            if (misalignment != 0) {
                int len = 4 - misalignment;
                for (i = 0; i < len; ++i) {
                    if (UNSAFE.getByte(null, address + (long)i) != 0) continue;
                    return i;
                }
            }
            while (i <= maxLength - 4 && !MathUtil.mathHasZeroByte(UNSAFE.getInt(null, address + (long)i))) {
                i += 4;
            }
        }
        while (i < maxLength && UNSAFE.getByte(null, address + (long)i) != 0) {
            ++i;
        }
        return i;
    }

    public static String memASCII(long address) {
        return MemoryUtil.memASCII(address, MemoryUtil.memLengthNT1(address, Integer.MAX_VALUE));
    }

    public static String memASCII(long address, int length) {
        if (length <= 0) {
            return "";
        }
        byte[] ascii = length <= ARRAY_TLC_SIZE ? ARRAY_TLC_BYTE.get() : new byte[length];
        MemoryUtil.memByteBuffer(address, length).get(ascii, 0, length);
        return new String(ascii, 0, 0, length);
    }

    @Nullable
    public static String memASCIISafe(long address) {
        return address == 0L ? null : MemoryUtil.memASCII(address, MemoryUtil.memLengthNT1(address, Integer.MAX_VALUE));
    }

    public static String memASCII(ByteBuffer buffer, int length) {
        return MemoryUtil.memASCII(MemoryUtil.memAddress(buffer), length);
    }

    public static String memUTF8(long address) {
        return MultiReleaseTextDecoding.decodeUTF8(address, MemoryUtil.memLengthNT1(address, Integer.MAX_VALUE));
    }

    public static String memUTF8(ByteBuffer buffer) {
        return MultiReleaseTextDecoding.decodeUTF8(MemoryUtil.memAddress(buffer), buffer.remaining());
    }

    @Nullable
    public static String memUTF8Safe(long address) {
        return address == 0L ? null : MultiReleaseTextDecoding.decodeUTF8(address, MemoryUtil.memLengthNT1(address, Integer.MAX_VALUE));
    }

    public static String memUTF8(ByteBuffer buffer, int length) {
        return MultiReleaseTextDecoding.decodeUTF8(MemoryUtil.memAddress(buffer), length);
    }

    public static String memUTF16(long address, int length) {
        if (length <= 0) {
            return "";
        }
        if (Checks.DEBUG) {
            int len = length << 1;
            byte[] bytes = len <= ARRAY_TLC_SIZE ? ARRAY_TLC_BYTE.get() : new byte[len];
            MemoryUtil.memByteBuffer(address, len).get(bytes, 0, len);
            return new String(bytes, 0, len, UTF16);
        }
        char[] chars = length <= ARRAY_TLC_SIZE ? ARRAY_TLC_CHAR.get() : new char[length];
        MemoryUtil.memCharBuffer(address, length).get(chars, 0, length);
        return new String(chars, 0, length);
    }

    public static String memUTF16(ByteBuffer buffer, int length) {
        return MemoryUtil.memUTF16(MemoryUtil.memAddress(buffer), length);
    }

    private static Unsafe getUnsafeInstance() {
        Field[] fields;
        for (Field field : fields = Unsafe.class.getDeclaredFields()) {
            int modifiers;
            if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
            try {
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                break;
            }
        }
        throw new UnsupportedOperationException("LWJGL requires sun.misc.Unsafe to be available.");
    }

    private static long getFieldOffset(Class<?> containerType, Class<?> fieldType, LongPredicate predicate) {
        for (Class<?> c = containerType; c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                long offset;
                if (!field.getType().isAssignableFrom(fieldType) || Modifier.isStatic(field.getModifiers()) || field.isSynthetic() || !predicate.test(offset = UNSAFE.objectFieldOffset(field))) continue;
                return offset;
            }
        }
        throw new UnsupportedOperationException("Failed to find field offset in class.");
    }

    private static long getFieldOffsetInt(Object container, int value) {
        return MemoryUtil.getFieldOffset(container.getClass(), Integer.TYPE, offset -> UNSAFE.getInt(container, offset) == value);
    }

    private static long getFieldOffsetObject(Object container, Object value) {
        return MemoryUtil.getFieldOffset(container.getClass(), value.getClass(), offset -> UNSAFE.getObject(container, offset) == value);
    }

    private static long getAddressOffset() {
        long MAGIC_ADDRESS = 0xDEADBEEF8BADF00DL & (Pointer.BITS32 ? 0xFFFFFFFFL : -1L);
        ByteBuffer bb = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(MAGIC_ADDRESS, 0L));
        return MemoryUtil.getFieldOffset(bb.getClass(), Long.TYPE, offset -> UNSAFE.getLong(bb, offset) == MAGIC_ADDRESS);
    }

    private static long getMarkOffset() {
        ByteBuffer bb = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(1L, 0L));
        return MemoryUtil.getFieldOffsetInt(bb, -1);
    }

    private static long getPositionOffset() {
        ByteBuffer bb = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(-1L, 219540062L));
        bb.position(16435934);
        return MemoryUtil.getFieldOffsetInt(bb, 16435934);
    }

    private static long getLimitOffset() {
        ByteBuffer bb = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(-1L, 219540062L));
        bb.limit(16435934);
        return MemoryUtil.getFieldOffsetInt(bb, 16435934);
    }

    private static long getCapacityOffset() {
        ByteBuffer bb = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(-1L, 219540062L));
        bb.limit(0);
        return MemoryUtil.getFieldOffsetInt(bb, 219540062);
    }

    static <T extends Buffer> T wrap(Class<? extends T> clazz, long address, int capacity) {
        Buffer buffer;
        try {
            buffer = (Buffer)UNSAFE.allocateInstance(clazz);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException(e);
        }
        UNSAFE.putLong(buffer, ADDRESS, address);
        UNSAFE.putInt(buffer, MARK, -1);
        UNSAFE.putInt(buffer, LIMIT, capacity);
        UNSAFE.putInt(buffer, CAPACITY, capacity);
        return (T)buffer;
    }

    static {
        ARRAY_TLC_SIZE = Configuration.ARRAY_TLC_SIZE.get(8192);
        ARRAY_TLC_BYTE = ThreadLocal.withInitial(() -> new byte[ARRAY_TLC_SIZE]);
        ARRAY_TLC_CHAR = ThreadLocal.withInitial(() -> new char[ARRAY_TLC_SIZE]);
        NATIVE_ORDER = ByteOrder.nativeOrder();
        UTF16 = NATIVE_ORDER == ByteOrder.LITTLE_ENDIAN ? StandardCharsets.UTF_16LE : StandardCharsets.UTF_16BE;
        Library.initialize();
        ByteBuffer bb = ByteBuffer.allocateDirect(0).order(NATIVE_ORDER);
        BUFFER_BYTE = bb.getClass();
        BUFFER_SHORT = bb.asShortBuffer().getClass();
        BUFFER_CHAR = bb.asCharBuffer().getClass();
        BUFFER_INT = bb.asIntBuffer().getClass();
        BUFFER_LONG = bb.asLongBuffer().getClass();
        BUFFER_FLOAT = bb.asFloatBuffer().getClass();
        BUFFER_DOUBLE = bb.asDoubleBuffer().getClass();
        UNSAFE = MemoryUtil.getUnsafeInstance();
        try {
            MARK = MemoryUtil.getMarkOffset();
            POSITION = MemoryUtil.getPositionOffset();
            LIMIT = MemoryUtil.getLimitOffset();
            CAPACITY = MemoryUtil.getCapacityOffset();
            ADDRESS = MemoryUtil.getAddressOffset();
            PARENT_BYTE = MemoryUtil.getFieldOffsetObject(bb.duplicate().order(bb.order()), bb);
            PARENT_SHORT = MemoryUtil.getFieldOffsetObject(bb.asShortBuffer(), bb);
            PARENT_CHAR = MemoryUtil.getFieldOffsetObject(bb.asCharBuffer(), bb);
            PARENT_INT = MemoryUtil.getFieldOffsetObject(bb.asIntBuffer(), bb);
            PARENT_LONG = MemoryUtil.getFieldOffsetObject(bb.asLongBuffer(), bb);
            PARENT_FLOAT = MemoryUtil.getFieldOffsetObject(bb.asFloatBuffer(), bb);
            PARENT_DOUBLE = MemoryUtil.getFieldOffsetObject(bb.asDoubleBuffer(), bb);
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException(t);
        }
        PAGE_SIZE = UNSAFE.pageSize();
        CACHE_LINE_SIZE = 64;
        FILL_PATTERN_32 = Integer.divideUnsigned(-1, 255);
        FILL_PATTERN_64 = Long.divideUnsigned(-1L, 255L);
    }

    public static interface MemoryAllocationReport {

        public static enum Aggregate {
            ALL,
            GROUP_BY_METHOD,
            GROUP_BY_STACKTRACE;

        }
    }

    public static interface MemoryAllocator {
        public long malloc(long var1);

        public long calloc(long var1, long var3);

        public long realloc(long var1, long var3);

        public void free(long var1);

        public long aligned_alloc(long var1, long var3);

        public void aligned_free(long var1);
    }

    static final class LazyInit {
        static final MemoryAllocator ALLOCATOR_IMPL;
        static final MemoryAllocator ALLOCATOR;

        static {
            boolean debug = Configuration.DEBUG_MEMORY_ALLOCATOR.get(false);
            ALLOCATOR_IMPL = MemoryManage.getInstance();
            ALLOCATOR = debug ? new MemoryManage.DebugAllocator(ALLOCATOR_IMPL) : ALLOCATOR_IMPL;
            APIUtil.apiLog("MemoryUtil allocator: " + ALLOCATOR.getClass().getSimpleName());
            if (debug && !Configuration.DEBUG_MEMORY_ALLOCATOR_FAST.get(false).booleanValue()) {
                APIUtil.apiLogMore("Reminder: enable Configuration.DEBUG_MEMORY_ALLOCATOR_FAST for low overhead allocation tracking.");
            }
        }
    }
}

