/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.FFIType;
import org.lwjgl.system.libffi.LibFFI;
import org.lwjgl.system.linux.LinuxLibrary;
import org.lwjgl.system.macosx.MacOSXLibrary;
import org.lwjgl.system.windows.WindowsLibrary;

public final class APIUtil {
    public static final PrintStream DEBUG_STREAM = APIUtil.getDebugStream();
    private static final Pattern API_VERSION_PATTERN;

    private static PrintStream getDebugStream() {
        PrintStream debugStream = System.err;
        Object state = Configuration.DEBUG_STREAM.get();
        if (state instanceof String) {
            try {
                Supplier factory = (Supplier)Class.forName((String)state).getConstructor(new Class[0]).newInstance(new Object[0]);
                debugStream = (PrintStream)factory.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (state instanceof Supplier) {
            debugStream = (PrintStream)((Supplier)state).get();
        } else if (state instanceof PrintStream) {
            debugStream = (PrintStream)state;
        }
        return debugStream;
    }

    public static void apiLog(CharSequence msg) {
        if (Checks.DEBUG) {
            DEBUG_STREAM.print("[LWJGL] " + msg + "\n");
        }
    }

    public static void apiLogMore(CharSequence msg) {
        if (Checks.DEBUG) {
            DEBUG_STREAM.print("\t" + msg + "\n");
        }
    }

    public static void apiLogMissing(String api, ByteBuffer functionName) {
        if (Checks.DEBUG) {
            String function = MemoryUtil.memASCII(functionName, functionName.remaining() - 1);
            DEBUG_STREAM.print("[LWJGL] Failed to locate address for " + api + " function " + function + "\n");
        }
    }

    public static SharedLibrary apiCreateLibrary(String name) {
        switch (Platform.get()) {
            case WINDOWS: {
                return new WindowsLibrary(name);
            }
            case LINUX: {
                return new LinuxLibrary(name);
            }
            case MACOSX: {
                return MacOSXLibrary.create(name);
            }
        }
        throw new IllegalStateException();
    }

    public static long apiGetFunctionAddress(FunctionProvider provider, String functionName) {
        long a = provider.getFunctionAddress(functionName);
        if (a == 0L) {
            APIUtil.requiredFunctionMissing(functionName);
        }
        return a;
    }

    private static void requiredFunctionMissing(String functionName) {
        if (!Configuration.DISABLE_FUNCTION_CHECKS.get(false).booleanValue()) {
            throw new NullPointerException("A required function is missing: " + functionName);
        }
    }

    public static long apiGetBytes(int elements, int elementShift) {
        return ((long)elements & 0xFFFFFFFFL) << elementShift;
    }

    public static long apiCheckAllocation(int elements, long bytes, long maxBytes) {
        if (Checks.DEBUG) {
            if (elements < 0) {
                throw new IllegalArgumentException("Invalid number of elements");
            }
            if (maxBytes + Long.MIN_VALUE < bytes + Long.MIN_VALUE) {
                throw new IllegalArgumentException("The request allocation is too large");
            }
        }
        return bytes;
    }

    @Nullable
    public static APIVersion apiParseVersion(Configuration<?> option) {
        Object state = option.get();
        APIVersion version = state instanceof String ? APIUtil.apiParseVersion((String)state) : (state instanceof APIVersion ? (APIVersion)state : null);
        return version;
    }

    public static APIVersion apiParseVersion(String version) {
        Matcher matcher = API_VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Malformed API version string [%s]", version));
        }
        return new APIVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(3), matcher.group(4));
    }

    public static void apiFilterExtensions(Set<String> extensions, Configuration<Object> option) {
        Object value = option.get();
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            String s = (String)value;
            if (s.indexOf(46) != -1) {
                try {
                    Predicate predicate = (Predicate)Class.forName(s).newInstance();
                    extensions.removeIf(predicate);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                for (String extension : s.split(",")) {
                    extensions.remove(extension);
                }
            }
        } else if (value instanceof List) {
            List list = (List)value;
            extensions.removeAll(list);
        } else if (value instanceof Predicate) {
            Predicate predicate = (Predicate)value;
            extensions.removeIf(predicate);
        } else {
            throw new IllegalStateException("Unsupported " + option.getProperty() + " value specified.");
        }
    }

    public static String apiUnknownToken(int token) {
        return APIUtil.apiUnknownToken("Unknown", token);
    }

    public static String apiUnknownToken(String description, int token) {
        return String.format("%s [0x%X]", description, token);
    }

    public static Map<Integer, String> apiClassTokens(@Nullable BiPredicate<Field, Integer> filter, @Nullable Map<Integer, String> target, Class<?> ... tokenClasses) {
        if (target == null) {
            target = new HashMap<Integer, String>(64);
        }
        int TOKEN_MODIFIERS = 25;
        for (Class<?> tokenClass : tokenClasses) {
            if (tokenClass == null) continue;
            for (Field field : tokenClass.getDeclaredFields()) {
                if ((field.getModifiers() & TOKEN_MODIFIERS) != TOKEN_MODIFIERS || field.getType() != Integer.TYPE) continue;
                try {
                    Integer value = field.getInt(null);
                    if (filter != null && !filter.test(field, value)) continue;
                    String name = target.get(value);
                    target.put(value, name == null ? field.getName() : name + "|" + field.getName());
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return target;
    }

    public static long apiArrayi(MemoryStack stack, Encoder encoder, CharSequence ... strings) {
        PointerBuffer pointers = stack.mallocPointer(strings.length);
        IntBuffer lengths = stack.mallocInt(strings.length);
        for (CharSequence s : strings) {
            ByteBuffer buffer = encoder.encode(s, false);
            pointers.put(buffer);
            lengths.put(buffer.capacity());
        }
        return pointers.address;
    }

    public static void apiArrayFree(long pointers, int length) {
        int i = length;
        while (--i >= 0) {
            MemoryUtil.nmemFree(MemoryUtil.memGetAddress(pointers + Integer.toUnsignedLong(i) * (long)MemoryStack.POINTER_SIZE));
        }
    }

    public static FFICIF apiCreateCIF(int abi, FFIType rtype, FFIType ... atypes) {
        MemoryUtil.MemoryAllocator allocator = MemoryUtil.getAllocator();
        PointerBuffer pArgTypes = PointerBuffer.create(allocator.malloc(atypes.length * MemoryStack.POINTER_SIZE), atypes.length);
        for (int i = 0; i < atypes.length; ++i) {
            pArgTypes.put(i, atypes[i]);
        }
        FFICIF cif = FFICIF.create(allocator.malloc(FFICIF.SIZEOF));
        int errcode = LibFFI.ffi_prep_cif(cif, abi, rtype, pArgTypes);
        if (errcode != 0) {
            throw new IllegalStateException("Failed to prepare libffi CIF: " + errcode);
        }
        return cif;
    }

    public static int apiStdcall() {
        return Platform.get() == Platform.WINDOWS && Pointer.BITS32 ? LibFFI.FFI_STDCALL : LibFFI.FFI_DEFAULT_ABI;
    }

    public static void apiClosureRet(long ret, boolean __result) {
        MemoryUtil.memPutAddress(ret, __result ? 1L : 0L);
    }

    public static void apiClosureRet(long ret, int __result) {
        MemoryUtil.memPutAddress(ret, (long)__result & 0xFFFFFFFFL);
    }

    public static void apiClosureRetP(long ret, long __result) {
        MemoryUtil.memPutAddress(ret, __result);
    }

    static {
        String PREFIX = "[^\\d\\n\\r]*";
        String VERSION = "(\\d+)[.](\\d+)(?:[.](\\S+))?";
        String IMPLEMENTATION = "(?:\\s+(.+?))?\\s*";
        API_VERSION_PATTERN = Pattern.compile("^" + PREFIX + VERSION + IMPLEMENTATION + "$", 32);
    }

    public static interface Encoder {
        public ByteBuffer encode(CharSequence var1, boolean var2);
    }

    public static class APIVersion
    implements Comparable<APIVersion> {
        public final int major;
        public final int minor;
        @Nullable
        public final String revision;
        @Nullable
        public final String implementation;

        public APIVersion(int major, int minor, @Nullable String revision, @Nullable String implementation) {
            this.major = major;
            this.minor = minor;
            this.revision = revision;
            this.implementation = implementation;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(16);
            sb.append(this.major).append('.').append(this.minor);
            if (this.revision != null) {
                sb.append('.').append(this.revision);
            }
            if (this.implementation != null) {
                sb.append(" (").append(this.implementation).append(')');
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof APIVersion)) {
                return false;
            }
            APIVersion that = (APIVersion)o;
            return this.major == that.major && this.minor == that.major && Objects.equals(this.revision, that.revision) && Objects.equals(this.implementation, that.implementation);
        }

        public int hashCode() {
            int result = this.major;
            result = 31 * result + this.minor;
            result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
            result = 31 * result + (this.implementation != null ? this.implementation.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(APIVersion other) {
            if (this.major != other.major) {
                return Integer.compare(this.major, other.major);
            }
            if (this.minor != other.minor) {
                return Integer.compare(this.minor, other.minor);
            }
            return 0;
        }
    }
}

