/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.utils.SpineUtils;

public class TransformConstraint
implements Updatable {
    final TransformConstraintData data;
    final Array<Bone> bones;
    Bone target;
    float mixRotate;
    float mixX;
    float mixY;
    float mixScaleX;
    float mixScaleY;
    float mixShearY;
    boolean active;
    final Vector2 temp = new Vector2();

    public TransformConstraint(TransformConstraintData transformConstraintData, Skeleton skeleton) {
        if (transformConstraintData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = transformConstraintData;
        this.bones = new Array(transformConstraintData.bones.size);
        for (BoneData boneData : transformConstraintData.bones) {
            this.bones.add(skeleton.bones.get(boneData.index));
        }
        this.target = skeleton.bones.get(transformConstraintData.target.index);
        this.mixRotate = transformConstraintData.mixRotate;
        this.mixX = transformConstraintData.mixX;
        this.mixY = transformConstraintData.mixY;
        this.mixScaleX = transformConstraintData.mixScaleX;
        this.mixScaleY = transformConstraintData.mixScaleY;
        this.mixShearY = transformConstraintData.mixShearY;
    }

    public void setToSetupPose() {
        TransformConstraintData transformConstraintData = this.data;
        this.mixRotate = transformConstraintData.mixRotate;
        this.mixX = transformConstraintData.mixX;
        this.mixY = transformConstraintData.mixY;
        this.mixScaleX = transformConstraintData.mixScaleX;
        this.mixScaleY = transformConstraintData.mixScaleY;
        this.mixShearY = transformConstraintData.mixShearY;
    }

    @Override
    public void update(Skeleton.Physics physics) {
        if (this.mixRotate == 0.0f && this.mixX == 0.0f && this.mixY == 0.0f && this.mixScaleX == 0.0f && this.mixScaleY == 0.0f && this.mixShearY == 0.0f) {
            return;
        }
        if (this.data.local) {
            if (this.data.relative) {
                this.applyRelativeLocal();
            } else {
                this.applyAbsoluteLocal();
            }
        } else if (this.data.relative) {
            this.applyRelativeWorld();
        } else {
            this.applyAbsoluteWorld();
        }
    }

    private void applyAbsoluteWorld() {
        float f = this.mixRotate;
        float f2 = this.mixX;
        float f3 = this.mixY;
        float f4 = this.mixScaleX;
        float f5 = this.mixScaleY;
        float f6 = this.mixShearY;
        boolean bl = f2 != 0.0f || f3 != 0.0f;
        Bone bone = this.target;
        float f7 = bone.a;
        float f8 = bone.b;
        float f9 = bone.c;
        float f10 = bone.d;
        float f11 = f7 * f10 - f8 * f9 > 0.0f ? (float)Math.PI / 180 : (float)(-Math.PI) / 180;
        float f12 = this.data.offsetRotation * f11;
        float f13 = this.data.offsetShearY * f11;
        T[] TArray = this.bones.items;
        int n = this.bones.size;
        for (int i = 0; i < n; ++i) {
            float f14;
            float f15;
            float f16;
            float f17;
            float f18;
            Bone bone2 = (Bone)TArray[i];
            if (f != 0.0f) {
                f18 = bone2.a;
                f17 = bone2.b;
                f16 = bone2.c;
                f15 = bone2.d;
                f14 = SpineUtils.atan2(f9, f7) - SpineUtils.atan2(f16, f18) + f12;
                if (f14 > (float)Math.PI) {
                    f14 -= (float)Math.PI * 2;
                } else if (f14 < (float)(-Math.PI)) {
                    f14 += (float)Math.PI * 2;
                }
                float f19 = SpineUtils.cos(f14 *= f);
                float f20 = SpineUtils.sin(f14);
                bone2.a = f19 * f18 - f20 * f16;
                bone2.b = f19 * f17 - f20 * f15;
                bone2.c = f20 * f18 + f19 * f16;
                bone2.d = f20 * f17 + f19 * f15;
            }
            if (bl) {
                Vector2 vector2 = this.temp;
                bone.localToWorld(vector2.set(this.data.offsetX, this.data.offsetY));
                bone2.worldX += (vector2.x - bone2.worldX) * f2;
                bone2.worldY += (vector2.y - bone2.worldY) * f3;
            }
            if (f4 != 0.0f) {
                f18 = (float)Math.sqrt(bone2.a * bone2.a + bone2.c * bone2.c);
                if (f18 != 0.0f) {
                    f18 = (f18 + ((float)Math.sqrt(f7 * f7 + f9 * f9) - f18 + this.data.offsetScaleX) * f4) / f18;
                }
                bone2.a *= f18;
                bone2.c *= f18;
            }
            if (f5 != 0.0f) {
                f18 = (float)Math.sqrt(bone2.b * bone2.b + bone2.d * bone2.d);
                if (f18 != 0.0f) {
                    f18 = (f18 + ((float)Math.sqrt(f8 * f8 + f10 * f10) - f18 + this.data.offsetScaleY) * f5) / f18;
                }
                bone2.b *= f18;
                bone2.d *= f18;
            }
            if (f6 > 0.0f) {
                f18 = bone2.b;
                f17 = bone2.d;
                f16 = SpineUtils.atan2(f17, f18);
                f15 = SpineUtils.atan2(f10, f8) - SpineUtils.atan2(f9, f7) - (f16 - SpineUtils.atan2(bone2.c, bone2.a));
                if (f15 > (float)Math.PI) {
                    f15 -= (float)Math.PI * 2;
                } else if (f15 < (float)(-Math.PI)) {
                    f15 += (float)Math.PI * 2;
                }
                f15 = f16 + (f15 + f13) * f6;
                f14 = (float)Math.sqrt(f18 * f18 + f17 * f17);
                bone2.b = SpineUtils.cos(f15) * f14;
                bone2.d = SpineUtils.sin(f15) * f14;
            }
            bone2.updateAppliedTransform();
        }
    }

    private void applyRelativeWorld() {
        float f = this.mixRotate;
        float f2 = this.mixX;
        float f3 = this.mixY;
        float f4 = this.mixScaleX;
        float f5 = this.mixScaleY;
        float f6 = this.mixShearY;
        boolean bl = f2 != 0.0f || f3 != 0.0f;
        Bone bone = this.target;
        float f7 = bone.a;
        float f8 = bone.b;
        float f9 = bone.c;
        float f10 = bone.d;
        float f11 = f7 * f10 - f8 * f9 > 0.0f ? (float)Math.PI / 180 : (float)(-Math.PI) / 180;
        float f12 = this.data.offsetRotation * f11;
        float f13 = this.data.offsetShearY * f11;
        T[] TArray = this.bones.items;
        int n = this.bones.size;
        for (int i = 0; i < n; ++i) {
            float f14;
            float f15;
            float f16;
            float f17;
            Bone bone2 = (Bone)TArray[i];
            if (f != 0.0f) {
                f17 = bone2.a;
                f16 = bone2.b;
                f15 = bone2.c;
                f14 = bone2.d;
                float f18 = SpineUtils.atan2(f9, f7) + f12;
                if (f18 > (float)Math.PI) {
                    f18 -= (float)Math.PI * 2;
                } else if (f18 < (float)(-Math.PI)) {
                    f18 += (float)Math.PI * 2;
                }
                float f19 = SpineUtils.cos(f18 *= f);
                float f20 = SpineUtils.sin(f18);
                bone2.a = f19 * f17 - f20 * f15;
                bone2.b = f19 * f16 - f20 * f14;
                bone2.c = f20 * f17 + f19 * f15;
                bone2.d = f20 * f16 + f19 * f14;
            }
            if (bl) {
                Vector2 vector2 = this.temp;
                bone.localToWorld(vector2.set(this.data.offsetX, this.data.offsetY));
                bone2.worldX += vector2.x * f2;
                bone2.worldY += vector2.y * f3;
            }
            if (f4 != 0.0f) {
                f17 = ((float)Math.sqrt(f7 * f7 + f9 * f9) - 1.0f + this.data.offsetScaleX) * f4 + 1.0f;
                bone2.a *= f17;
                bone2.c *= f17;
            }
            if (f5 != 0.0f) {
                f17 = ((float)Math.sqrt(f8 * f8 + f10 * f10) - 1.0f + this.data.offsetScaleY) * f5 + 1.0f;
                bone2.b *= f17;
                bone2.d *= f17;
            }
            if (f6 > 0.0f) {
                f17 = SpineUtils.atan2(f10, f8) - SpineUtils.atan2(f9, f7);
                if (f17 > (float)Math.PI) {
                    f17 -= (float)Math.PI * 2;
                } else if (f17 < (float)(-Math.PI)) {
                    f17 += (float)Math.PI * 2;
                }
                f16 = bone2.b;
                f15 = bone2.d;
                f17 = SpineUtils.atan2(f15, f16) + (f17 - 1.5707964f + f13) * f6;
                f14 = (float)Math.sqrt(f16 * f16 + f15 * f15);
                bone2.b = SpineUtils.cos(f17) * f14;
                bone2.d = SpineUtils.sin(f17) * f14;
            }
            bone2.updateAppliedTransform();
        }
    }

    private void applyAbsoluteLocal() {
        float f = this.mixRotate;
        float f2 = this.mixX;
        float f3 = this.mixY;
        float f4 = this.mixScaleX;
        float f5 = this.mixScaleY;
        float f6 = this.mixShearY;
        Bone bone = this.target;
        T[] TArray = this.bones.items;
        int n = this.bones.size;
        for (int i = 0; i < n; ++i) {
            Bone bone2 = (Bone)TArray[i];
            float f7 = bone2.arotation;
            if (f != 0.0f) {
                f7 += (bone.arotation - f7 + this.data.offsetRotation) * f;
            }
            float f8 = bone2.ax;
            float f9 = bone2.ay;
            f8 += (bone.ax - f8 + this.data.offsetX) * f2;
            f9 += (bone.ay - f9 + this.data.offsetY) * f3;
            float f10 = bone2.ascaleX;
            float f11 = bone2.ascaleY;
            if (f4 != 0.0f && f10 != 0.0f) {
                f10 = (f10 + (bone.ascaleX - f10 + this.data.offsetScaleX) * f4) / f10;
            }
            if (f5 != 0.0f && f11 != 0.0f) {
                f11 = (f11 + (bone.ascaleY - f11 + this.data.offsetScaleY) * f5) / f11;
            }
            float f12 = bone2.ashearY;
            if (f6 != 0.0f) {
                f12 += (bone.ashearY - f12 + this.data.offsetShearY) * f6;
            }
            bone2.updateWorldTransform(f8, f9, f7, f10, f11, bone2.ashearX, f12);
        }
    }

    private void applyRelativeLocal() {
        float f = this.mixRotate;
        float f2 = this.mixX;
        float f3 = this.mixY;
        float f4 = this.mixScaleX;
        float f5 = this.mixScaleY;
        float f6 = this.mixShearY;
        Bone bone = this.target;
        T[] TArray = this.bones.items;
        int n = this.bones.size;
        for (int i = 0; i < n; ++i) {
            Bone bone2 = (Bone)TArray[i];
            float f7 = bone2.arotation + (bone.arotation + this.data.offsetRotation) * f;
            float f8 = bone2.ax + (bone.ax + this.data.offsetX) * f2;
            float f9 = bone2.ay + (bone.ay + this.data.offsetY) * f3;
            float f10 = bone2.ascaleX * ((bone.ascaleX - 1.0f + this.data.offsetScaleX) * f4 + 1.0f);
            float f11 = bone2.ascaleY * ((bone.ascaleY - 1.0f + this.data.offsetScaleY) * f5 + 1.0f);
            float f12 = bone2.ashearY + (bone.ashearY + this.data.offsetShearY) * f6;
            bone2.updateWorldTransform(f8, f9, f7, f10, f11, bone2.ashearX, f12);
        }
    }

    public String toString() {
        return this.data.name;
    }
}

