/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.zip.InflaterInputStream;

public class PixmapIO {
    public static Pixmap readCIM(FileHandle file) {
        return CIM.read(file);
    }

    private static class CIM {
        private static final byte[] writeBuffer = new byte[32000];
        private static final byte[] readBuffer = new byte[32000];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Pixmap read(FileHandle file) {
            Object object;
            DataInputStream in = null;
            try {
                in = new DataInputStream(new InflaterInputStream(new BufferedInputStream(file.read())));
                int width = in.readInt();
                int height = in.readInt();
                Pixmap.Format format = Pixmap.Format.fromGdx2DPixmapFormat(in.readInt());
                Pixmap pixmap = new Pixmap(width, height, format);
                ByteBuffer pixelBuf = pixmap.getPixels();
                ((Buffer)pixelBuf).position(0);
                ((Buffer)pixelBuf).limit(pixelBuf.capacity());
                object = readBuffer;
                synchronized (readBuffer) {
                    int readBytes = 0;
                    while ((readBytes = in.read(readBuffer)) > 0) {
                        pixelBuf.put(readBuffer, 0, readBytes);
                    }
                    // ** MonitorExit[var7_8 /* !! */ ] (shouldn't be in output)
                    ((Buffer)pixelBuf).position(0);
                    ((Buffer)pixelBuf).limit(pixelBuf.capacity());
                    object = pixmap;
                }
            }
            catch (Exception e) {
                try {
                    throw new GdxRuntimeException("Couldn't read Pixmap from file '" + file + "'", e);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            {
                StreamUtils.closeQuietly(in);
                return object;
            }
        }
    }
}

