/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.glfw.EventLoop;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWDropCallback;
import org.lwjgl.glfw.GLFWDropCallbackI;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowCloseCallback;
import org.lwjgl.glfw.GLFWWindowCloseCallbackI;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl.glfw.GLFWWindowIconifyCallback;
import org.lwjgl.glfw.GLFWWindowIconifyCallbackI;
import org.lwjgl.glfw.GLFWWindowMaximizeCallback;
import org.lwjgl.glfw.GLFWWindowMaximizeCallbackI;
import org.lwjgl.glfw.GLFWWindowRefreshCallback;
import org.lwjgl.glfw.GLFWWindowRefreshCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.Struct;

public class GLFW {
    private static final SharedLibrary GLFW = Library.loadNative(GLFW.class, "org.lwjgl.glfw", Configuration.GLFW_LIBRARY_NAME.get(Platform.mapLibraryNameBundled("glfw")), true);

    protected GLFW() {
        throw new UnsupportedOperationException();
    }

    public static boolean glfwInit() {
        long __functionAddress = Functions.Init;
        EventLoop.check();
        return JNI.invokeI(__functionAddress) != 0;
    }

    public static void glfwTerminate() {
        long __functionAddress = Functions.Terminate;
        JNI.invokeV(__functionAddress);
    }

    public static void glfwInitHint(int hint, int value) {
        long __functionAddress = Functions.InitHint;
        JNI.invokeV(hint, value, __functionAddress);
    }

    public static long nglfwSetErrorCallback(long cbfun) {
        long __functionAddress = Functions.SetErrorCallback;
        return JNI.invokePP(cbfun, __functionAddress);
    }

    @Nullable
    public static GLFWErrorCallback glfwSetErrorCallback(@Nullable GLFWErrorCallbackI cbfun) {
        return GLFWErrorCallback.createSafe(org.lwjgl.glfw.GLFW.nglfwSetErrorCallback(MemoryUtil.memAddressSafe(cbfun)));
    }

    public static long glfwGetPrimaryMonitor() {
        long __functionAddress = Functions.GetPrimaryMonitor;
        return JNI.invokeP(__functionAddress);
    }

    public static void nglfwGetMonitorPos(long monitor, long xpos, long ypos) {
        long __functionAddress = Functions.GetMonitorPos;
        if (Checks.CHECKS) {
            Checks.check(monitor);
        }
        JNI.invokePPPV(monitor, xpos, ypos, __functionAddress);
    }

    public static void glfwGetMonitorPos(long monitor, @Nullable IntBuffer xpos, @Nullable IntBuffer ypos) {
        if (Checks.CHECKS) {
            Checks.checkSafe(xpos, 1);
            Checks.checkSafe(ypos, 1);
        }
        org.lwjgl.glfw.GLFW.nglfwGetMonitorPos(monitor, MemoryUtil.memAddressSafe(xpos), MemoryUtil.memAddressSafe(ypos));
    }

    public static void nglfwGetMonitorWorkarea(long monitor, long xpos, long ypos, long width, long height) {
        long __functionAddress = Functions.GetMonitorWorkarea;
        if (Checks.CHECKS) {
            Checks.check(monitor);
        }
        JNI.invokePPPPPV(monitor, xpos, ypos, width, height, __functionAddress);
    }

    public static void glfwGetMonitorWorkarea(long monitor, @Nullable IntBuffer xpos, @Nullable IntBuffer ypos, @Nullable IntBuffer width, @Nullable IntBuffer height) {
        if (Checks.CHECKS) {
            Checks.checkSafe(xpos, 1);
            Checks.checkSafe(ypos, 1);
            Checks.checkSafe(width, 1);
            Checks.checkSafe(height, 1);
        }
        org.lwjgl.glfw.GLFW.nglfwGetMonitorWorkarea(monitor, MemoryUtil.memAddressSafe(xpos), MemoryUtil.memAddressSafe(ypos), MemoryUtil.memAddressSafe(width), MemoryUtil.memAddressSafe(height));
    }

    public static long nglfwGetMonitorName(long monitor) {
        long __functionAddress = Functions.GetMonitorName;
        if (Checks.CHECKS) {
            Checks.check(monitor);
        }
        return JNI.invokePP(monitor, __functionAddress);
    }

    @Nullable
    public static String glfwGetMonitorName(long monitor) {
        long __result = org.lwjgl.glfw.GLFW.nglfwGetMonitorName(monitor);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static long nglfwGetVideoMode(long monitor) {
        long __functionAddress = Functions.GetVideoMode;
        if (Checks.CHECKS) {
            Checks.check(monitor);
        }
        return JNI.invokePP(monitor, __functionAddress);
    }

    @Nullable
    public static GLFWVidMode glfwGetVideoMode(long monitor) {
        long __result = org.lwjgl.glfw.GLFW.nglfwGetVideoMode(monitor);
        return GLFWVidMode.createSafe(__result);
    }

    public static void glfwDefaultWindowHints() {
        long __functionAddress = Functions.DefaultWindowHints;
        JNI.invokeV(__functionAddress);
    }

    public static void glfwWindowHint(int hint, int value) {
        long __functionAddress = Functions.WindowHint;
        JNI.invokeV(hint, value, __functionAddress);
    }

    public static long nglfwCreateWindow(int width, int height, long title, long monitor, long share) {
        long __functionAddress = Functions.CreateWindow;
        return JNI.invokePPPP(width, height, title, monitor, share, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glfwCreateWindow(int width, int height, CharSequence title, long monitor, long share) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(title, true);
            long titleEncoded = stack.getPointerAddress();
            long l = org.lwjgl.glfw.GLFW.nglfwCreateWindow(width, height, titleEncoded, monitor, share);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glfwDestroyWindow(long window) {
        long __functionAddress = Functions.DestroyWindow;
        JNI.invokePV(window, __functionAddress);
    }

    public static boolean glfwWindowShouldClose(long window) {
        long __functionAddress = Functions.WindowShouldClose;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        return JNI.invokePI(window, __functionAddress) != 0;
    }

    public static void glfwSetWindowShouldClose(long window, boolean value) {
        long __functionAddress = Functions.SetWindowShouldClose;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        JNI.invokePV(window, value ? 1 : 0, __functionAddress);
    }

    public static void nglfwSetWindowIcon(long window, int count, long images) {
        long __functionAddress = Functions.SetWindowIcon;
        if (Checks.CHECKS) {
            Checks.check(window);
            if (images != 0L) {
                Struct.validate(images, count, GLFWImage.SIZEOF, GLFWImage::validate);
            }
        }
        JNI.invokePPV(window, count, images, __functionAddress);
    }

    public static void glfwSetWindowIcon(long window, @Nullable GLFWImage.Buffer images) {
        org.lwjgl.glfw.GLFW.nglfwSetWindowIcon(window, Checks.remainingSafe(images), MemoryUtil.memAddressSafe(images));
    }

    public static void glfwSetWindowPos(long window, int xpos, int ypos) {
        long __functionAddress = Functions.SetWindowPos;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        JNI.invokePV(window, xpos, ypos, __functionAddress);
    }

    public static void nglfwGetWindowSize(long window, long width, long height) {
        long __functionAddress = Functions.GetWindowSize;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        JNI.invokePPPV(window, width, height, __functionAddress);
    }

    public static void glfwGetWindowSize(long window, @Nullable IntBuffer width, @Nullable IntBuffer height) {
        if (Checks.CHECKS) {
            Checks.checkSafe(width, 1);
            Checks.checkSafe(height, 1);
        }
        org.lwjgl.glfw.GLFW.nglfwGetWindowSize(window, MemoryUtil.memAddressSafe(width), MemoryUtil.memAddressSafe(height));
    }

    public static void glfwSetWindowSizeLimits(long window, int minwidth, int minheight, int maxwidth, int maxheight) {
        long __functionAddress = Functions.SetWindowSizeLimits;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        JNI.invokePV(window, minwidth, minheight, maxwidth, maxheight, __functionAddress);
    }

    public static void nglfwGetFramebufferSize(long window, long width, long height) {
        long __functionAddress = Functions.GetFramebufferSize;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        JNI.invokePPPV(window, width, height, __functionAddress);
    }

    public static void glfwGetFramebufferSize(long window, @Nullable IntBuffer width, @Nullable IntBuffer height) {
        if (Checks.CHECKS) {
            Checks.checkSafe(width, 1);
            Checks.checkSafe(height, 1);
        }
        org.lwjgl.glfw.GLFW.nglfwGetFramebufferSize(window, MemoryUtil.memAddressSafe(width), MemoryUtil.memAddressSafe(height));
    }

    public static void glfwMaximizeWindow(long window) {
        long __functionAddress = Functions.MaximizeWindow;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        JNI.invokePV(window, __functionAddress);
    }

    public static void glfwShowWindow(long window) {
        long __functionAddress = Functions.ShowWindow;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        JNI.invokePV(window, __functionAddress);
    }

    public static void glfwHideWindow(long window) {
        long __functionAddress = Functions.HideWindow;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        JNI.invokePV(window, __functionAddress);
    }

    public static long nglfwSetWindowCloseCallback(long window, long cbfun) {
        long __functionAddress = Functions.SetWindowCloseCallback;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        return JNI.invokePPP(window, cbfun, __functionAddress);
    }

    @Nullable
    public static GLFWWindowCloseCallback glfwSetWindowCloseCallback(long window, @Nullable GLFWWindowCloseCallbackI cbfun) {
        return GLFWWindowCloseCallback.createSafe(org.lwjgl.glfw.GLFW.nglfwSetWindowCloseCallback(window, MemoryUtil.memAddressSafe(cbfun)));
    }

    public static long nglfwSetWindowRefreshCallback(long window, long cbfun) {
        long __functionAddress = Functions.SetWindowRefreshCallback;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        return JNI.invokePPP(window, cbfun, __functionAddress);
    }

    @Nullable
    public static GLFWWindowRefreshCallback glfwSetWindowRefreshCallback(long window, @Nullable GLFWWindowRefreshCallbackI cbfun) {
        return GLFWWindowRefreshCallback.createSafe(org.lwjgl.glfw.GLFW.nglfwSetWindowRefreshCallback(window, MemoryUtil.memAddressSafe(cbfun)));
    }

    public static long nglfwSetWindowFocusCallback(long window, long cbfun) {
        long __functionAddress = Functions.SetWindowFocusCallback;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        return JNI.invokePPP(window, cbfun, __functionAddress);
    }

    @Nullable
    public static GLFWWindowFocusCallback glfwSetWindowFocusCallback(long window, @Nullable GLFWWindowFocusCallbackI cbfun) {
        return GLFWWindowFocusCallback.createSafe(org.lwjgl.glfw.GLFW.nglfwSetWindowFocusCallback(window, MemoryUtil.memAddressSafe(cbfun)));
    }

    public static long nglfwSetWindowIconifyCallback(long window, long cbfun) {
        long __functionAddress = Functions.SetWindowIconifyCallback;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        return JNI.invokePPP(window, cbfun, __functionAddress);
    }

    @Nullable
    public static GLFWWindowIconifyCallback glfwSetWindowIconifyCallback(long window, @Nullable GLFWWindowIconifyCallbackI cbfun) {
        return GLFWWindowIconifyCallback.createSafe(org.lwjgl.glfw.GLFW.nglfwSetWindowIconifyCallback(window, MemoryUtil.memAddressSafe(cbfun)));
    }

    public static long nglfwSetWindowMaximizeCallback(long window, long cbfun) {
        long __functionAddress = Functions.SetWindowMaximizeCallback;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        return JNI.invokePPP(window, cbfun, __functionAddress);
    }

    @Nullable
    public static GLFWWindowMaximizeCallback glfwSetWindowMaximizeCallback(long window, @Nullable GLFWWindowMaximizeCallbackI cbfun) {
        return GLFWWindowMaximizeCallback.createSafe(org.lwjgl.glfw.GLFW.nglfwSetWindowMaximizeCallback(window, MemoryUtil.memAddressSafe(cbfun)));
    }

    public static long nglfwSetFramebufferSizeCallback(long window, long cbfun) {
        long __functionAddress = Functions.SetFramebufferSizeCallback;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        return JNI.invokePPP(window, cbfun, __functionAddress);
    }

    @Nullable
    public static GLFWFramebufferSizeCallback glfwSetFramebufferSizeCallback(long window, @Nullable GLFWFramebufferSizeCallbackI cbfun) {
        return GLFWFramebufferSizeCallback.createSafe(org.lwjgl.glfw.GLFW.nglfwSetFramebufferSizeCallback(window, MemoryUtil.memAddressSafe(cbfun)));
    }

    public static void glfwPollEvents() {
        long __functionAddress = Functions.PollEvents;
        JNI.invokeV(__functionAddress);
    }

    public static int glfwGetMouseButton(long window, int button) {
        long __functionAddress = Functions.GetMouseButton;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        return JNI.invokePI(window, button, __functionAddress);
    }

    public static void glfwDestroyCursor(long cursor) {
        long __functionAddress = Functions.DestroyCursor;
        if (Checks.CHECKS) {
            Checks.check(cursor);
        }
        JNI.invokePV(cursor, __functionAddress);
    }

    public static long nglfwSetKeyCallback(long window, long cbfun) {
        long __functionAddress = Functions.SetKeyCallback;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        return JNI.invokePPP(window, cbfun, __functionAddress);
    }

    @Nullable
    public static GLFWKeyCallback glfwSetKeyCallback(long window, @Nullable GLFWKeyCallbackI cbfun) {
        return GLFWKeyCallback.createSafe(org.lwjgl.glfw.GLFW.nglfwSetKeyCallback(window, MemoryUtil.memAddressSafe(cbfun)));
    }

    public static long nglfwSetCharCallback(long window, long cbfun) {
        long __functionAddress = Functions.SetCharCallback;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        return JNI.invokePPP(window, cbfun, __functionAddress);
    }

    @Nullable
    public static GLFWCharCallback glfwSetCharCallback(long window, @Nullable GLFWCharCallbackI cbfun) {
        return GLFWCharCallback.createSafe(org.lwjgl.glfw.GLFW.nglfwSetCharCallback(window, MemoryUtil.memAddressSafe(cbfun)));
    }

    public static long nglfwSetMouseButtonCallback(long window, long cbfun) {
        long __functionAddress = Functions.SetMouseButtonCallback;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        return JNI.invokePPP(window, cbfun, __functionAddress);
    }

    @Nullable
    public static GLFWMouseButtonCallback glfwSetMouseButtonCallback(long window, @Nullable GLFWMouseButtonCallbackI cbfun) {
        return GLFWMouseButtonCallback.createSafe(org.lwjgl.glfw.GLFW.nglfwSetMouseButtonCallback(window, MemoryUtil.memAddressSafe(cbfun)));
    }

    public static long nglfwSetCursorPosCallback(long window, long cbfun) {
        long __functionAddress = Functions.SetCursorPosCallback;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        return JNI.invokePPP(window, cbfun, __functionAddress);
    }

    @Nullable
    public static GLFWCursorPosCallback glfwSetCursorPosCallback(long window, @Nullable GLFWCursorPosCallbackI cbfun) {
        return GLFWCursorPosCallback.createSafe(org.lwjgl.glfw.GLFW.nglfwSetCursorPosCallback(window, MemoryUtil.memAddressSafe(cbfun)));
    }

    public static long nglfwSetScrollCallback(long window, long cbfun) {
        long __functionAddress = Functions.SetScrollCallback;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        return JNI.invokePPP(window, cbfun, __functionAddress);
    }

    @Nullable
    public static GLFWScrollCallback glfwSetScrollCallback(long window, @Nullable GLFWScrollCallbackI cbfun) {
        return GLFWScrollCallback.createSafe(org.lwjgl.glfw.GLFW.nglfwSetScrollCallback(window, MemoryUtil.memAddressSafe(cbfun)));
    }

    public static long nglfwSetDropCallback(long window, long cbfun) {
        long __functionAddress = Functions.SetDropCallback;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        return JNI.invokePPP(window, cbfun, __functionAddress);
    }

    @Nullable
    public static GLFWDropCallback glfwSetDropCallback(long window, @Nullable GLFWDropCallbackI cbfun) {
        return GLFWDropCallback.createSafe(org.lwjgl.glfw.GLFW.nglfwSetDropCallback(window, MemoryUtil.memAddressSafe(cbfun)));
    }

    public static double glfwGetTime() {
        long __functionAddress = Functions.GetTime;
        return JNI.invokeD(__functionAddress);
    }

    public static void glfwMakeContextCurrent(long window) {
        long __functionAddress = Functions.MakeContextCurrent;
        JNI.invokePV(window, __functionAddress);
    }

    public static void glfwSwapBuffers(long window) {
        long __functionAddress = Functions.SwapBuffers;
        if (Checks.CHECKS) {
            Checks.check(window);
        }
        JNI.invokePV(window, __functionAddress);
    }

    public static void glfwSwapInterval(int interval) {
        long __functionAddress = Functions.SwapInterval;
        JNI.invokeV(interval, __functionAddress);
    }

    public static int nglfwExtensionSupported(long extension) {
        long __functionAddress = Functions.ExtensionSupported;
        return JNI.invokePI(extension, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean glfwExtensionSupported(CharSequence extension) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(extension, true);
            long extensionEncoded = stack.getPointerAddress();
            boolean bl = org.lwjgl.glfw.GLFW.nglfwExtensionSupported(extensionEncoded) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static /* synthetic */ SharedLibrary access$000() {
        return GLFW;
    }

    public static final class Functions {
        public static final long Init = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwInit");
        public static final long Terminate = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwTerminate");
        public static final long InitHint = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwInitHint");
        public static final long InitAllocator = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwInitAllocator");
        public static final long GetVersion = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetVersion");
        public static final long GetVersionString = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetVersionString");
        public static final long GetError = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetError");
        public static final long SetErrorCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetErrorCallback");
        public static final long GetPlatform = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetPlatform");
        public static final long PlatformSupported = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwPlatformSupported");
        public static final long GetMonitors = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetMonitors");
        public static final long GetPrimaryMonitor = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetPrimaryMonitor");
        public static final long GetMonitorPos = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetMonitorPos");
        public static final long GetMonitorWorkarea = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetMonitorWorkarea");
        public static final long GetMonitorPhysicalSize = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetMonitorPhysicalSize");
        public static final long GetMonitorContentScale = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetMonitorContentScale");
        public static final long GetMonitorName = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetMonitorName");
        public static final long SetMonitorUserPointer = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetMonitorUserPointer");
        public static final long GetMonitorUserPointer = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetMonitorUserPointer");
        public static final long SetMonitorCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetMonitorCallback");
        public static final long GetVideoModes = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetVideoModes");
        public static final long GetVideoMode = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetVideoMode");
        public static final long SetGamma = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetGamma");
        public static final long GetGammaRamp = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetGammaRamp");
        public static final long SetGammaRamp = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetGammaRamp");
        public static final long DefaultWindowHints = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwDefaultWindowHints");
        public static final long WindowHint = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwWindowHint");
        public static final long WindowHintString = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwWindowHintString");
        public static final long CreateWindow = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwCreateWindow");
        public static final long DestroyWindow = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwDestroyWindow");
        public static final long WindowShouldClose = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwWindowShouldClose");
        public static final long SetWindowShouldClose = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowShouldClose");
        public static final long SetWindowTitle = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowTitle");
        public static final long SetWindowIcon = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowIcon");
        public static final long GetWindowPos = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetWindowPos");
        public static final long SetWindowPos = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowPos");
        public static final long GetWindowSize = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetWindowSize");
        public static final long SetWindowSizeLimits = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowSizeLimits");
        public static final long SetWindowAspectRatio = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowAspectRatio");
        public static final long SetWindowSize = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowSize");
        public static final long GetFramebufferSize = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetFramebufferSize");
        public static final long GetWindowFrameSize = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetWindowFrameSize");
        public static final long GetWindowContentScale = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetWindowContentScale");
        public static final long GetWindowOpacity = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetWindowOpacity");
        public static final long SetWindowOpacity = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowOpacity");
        public static final long IconifyWindow = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwIconifyWindow");
        public static final long RestoreWindow = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwRestoreWindow");
        public static final long MaximizeWindow = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwMaximizeWindow");
        public static final long ShowWindow = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwShowWindow");
        public static final long HideWindow = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwHideWindow");
        public static final long FocusWindow = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwFocusWindow");
        public static final long RequestWindowAttention = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwRequestWindowAttention");
        public static final long GetWindowMonitor = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetWindowMonitor");
        public static final long SetWindowMonitor = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowMonitor");
        public static final long GetWindowAttrib = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetWindowAttrib");
        public static final long SetWindowAttrib = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowAttrib");
        public static final long SetWindowUserPointer = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowUserPointer");
        public static final long GetWindowUserPointer = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetWindowUserPointer");
        public static final long SetWindowPosCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowPosCallback");
        public static final long SetWindowSizeCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowSizeCallback");
        public static final long SetWindowCloseCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowCloseCallback");
        public static final long SetWindowRefreshCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowRefreshCallback");
        public static final long SetWindowFocusCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowFocusCallback");
        public static final long SetWindowIconifyCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowIconifyCallback");
        public static final long SetWindowMaximizeCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowMaximizeCallback");
        public static final long SetFramebufferSizeCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetFramebufferSizeCallback");
        public static final long SetWindowContentScaleCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetWindowContentScaleCallback");
        public static final long PollEvents = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwPollEvents");
        public static final long WaitEvents = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwWaitEvents");
        public static final long WaitEventsTimeout = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwWaitEventsTimeout");
        public static final long PostEmptyEvent = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwPostEmptyEvent");
        public static final long GetInputMode = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetInputMode");
        public static final long SetInputMode = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetInputMode");
        public static final long RawMouseMotionSupported = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwRawMouseMotionSupported");
        public static final long GetKeyName = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetKeyName");
        public static final long GetKeyScancode = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetKeyScancode");
        public static final long GetKey = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetKey");
        public static final long GetMouseButton = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetMouseButton");
        public static final long GetCursorPos = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetCursorPos");
        public static final long SetCursorPos = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetCursorPos");
        public static final long CreateCursor = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwCreateCursor");
        public static final long CreateStandardCursor = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwCreateStandardCursor");
        public static final long DestroyCursor = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwDestroyCursor");
        public static final long SetCursor = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetCursor");
        public static final long SetKeyCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetKeyCallback");
        public static final long SetCharCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetCharCallback");
        public static final long SetCharModsCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetCharModsCallback");
        public static final long SetMouseButtonCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetMouseButtonCallback");
        public static final long SetCursorPosCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetCursorPosCallback");
        public static final long SetCursorEnterCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetCursorEnterCallback");
        public static final long SetScrollCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetScrollCallback");
        public static final long SetDropCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetDropCallback");
        public static final long JoystickPresent = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwJoystickPresent");
        public static final long GetJoystickAxes = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetJoystickAxes");
        public static final long GetJoystickButtons = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetJoystickButtons");
        public static final long GetJoystickHats = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetJoystickHats");
        public static final long GetJoystickName = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetJoystickName");
        public static final long GetJoystickGUID = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetJoystickGUID");
        public static final long SetJoystickUserPointer = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetJoystickUserPointer");
        public static final long GetJoystickUserPointer = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetJoystickUserPointer");
        public static final long JoystickIsGamepad = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwJoystickIsGamepad");
        public static final long SetJoystickCallback = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetJoystickCallback");
        public static final long UpdateGamepadMappings = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwUpdateGamepadMappings");
        public static final long GetGamepadName = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetGamepadName");
        public static final long GetGamepadState = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetGamepadState");
        public static final long SetClipboardString = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetClipboardString");
        public static final long GetClipboardString = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetClipboardString");
        public static final long GetTime = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetTime");
        public static final long SetTime = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSetTime");
        public static final long GetTimerValue = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetTimerValue");
        public static final long GetTimerFrequency = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetTimerFrequency");
        public static final long MakeContextCurrent = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwMakeContextCurrent");
        public static final long GetCurrentContext = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetCurrentContext");
        public static final long SwapBuffers = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSwapBuffers");
        public static final long SwapInterval = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwSwapInterval");
        public static final long ExtensionSupported = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwExtensionSupported");
        public static final long GetProcAddress = APIUtil.apiGetFunctionAddress(org.lwjgl.glfw.GLFW.access$000(), "glfwGetProcAddress");
    }
}

