/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.utils.SpineUtils;

public class IkConstraint
implements Updatable {
    final IkConstraintData data;
    final Array<Bone> bones;
    Bone target;
    int bendDirection;
    boolean compress;
    boolean stretch;
    float mix = 1.0f;
    float softness;
    boolean active;

    public IkConstraint(IkConstraintData ikConstraintData, Skeleton skeleton) {
        if (ikConstraintData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = ikConstraintData;
        this.mix = ikConstraintData.mix;
        this.softness = ikConstraintData.softness;
        this.bendDirection = ikConstraintData.bendDirection;
        this.compress = ikConstraintData.compress;
        this.stretch = ikConstraintData.stretch;
        this.bones = new Array(ikConstraintData.bones.size);
        for (BoneData boneData : ikConstraintData.bones) {
            this.bones.add(skeleton.findBone(boneData.name));
        }
        this.target = skeleton.findBone(ikConstraintData.target.name);
    }

    public IkConstraint(IkConstraint ikConstraint, Skeleton skeleton) {
        if (ikConstraint == null) {
            throw new IllegalArgumentException("constraint cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = ikConstraint.data;
        this.bones = new Array(ikConstraint.bones.size);
        for (Bone bone : ikConstraint.bones) {
            this.bones.add(skeleton.bones.get(bone.data.index));
        }
        this.target = skeleton.bones.get(ikConstraint.target.data.index);
        this.mix = ikConstraint.mix;
        this.softness = ikConstraint.softness;
        this.bendDirection = ikConstraint.bendDirection;
        this.compress = ikConstraint.compress;
        this.stretch = ikConstraint.stretch;
    }

    @Override
    public void update() {
        if (this.mix == 0.0f) {
            return;
        }
        Bone bone = this.target;
        T[] TArray = this.bones.items;
        switch (this.bones.size) {
            case 1: {
                IkConstraint.apply((Bone)TArray[0], bone.worldX, bone.worldY, this.compress, this.stretch, this.data.uniform, this.mix);
                break;
            }
            case 2: {
                IkConstraint.apply((Bone)TArray[0], (Bone)TArray[1], bone.worldX, bone.worldY, this.bendDirection, this.stretch, this.data.uniform, this.softness, this.mix);
            }
        }
    }

    public String toString() {
        return this.data.name;
    }

    public static void apply(Bone bone, float f, float f2, boolean bl, boolean bl2, boolean bl3, float f3) {
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        if (bone == null) {
            throw new IllegalArgumentException("bone cannot be null.");
        }
        Bone bone2 = bone.parent;
        float f11 = bone2.a;
        float f12 = bone2.b;
        float f13 = bone2.c;
        float f14 = bone2.d;
        float f15 = -bone.ashearX - bone.arotation;
        switch (bone.data.transformMode) {
            case onlyTranslation: {
                f10 = f - bone.worldX;
                f9 = f2 - bone.worldY;
                break;
            }
            case noRotationOrReflection: {
                f8 = Math.abs(f11 * f14 - f12 * f13) / (f11 * f11 + f13 * f13);
                f7 = f11 / bone.skeleton.scaleX;
                f6 = f13 / bone.skeleton.scaleY;
                f12 = -f6 * f8 * bone.skeleton.scaleX;
                f14 = f7 * f8 * bone.skeleton.scaleY;
                f15 += SpineUtils.atan2(f6, f7) * 57.295776f;
            }
            default: {
                f5 = f - bone2.worldX;
                f4 = f2 - bone2.worldY;
                float f16 = f11 * f14 - f12 * f13;
                f10 = (f5 * f14 - f4 * f12) / f16 - bone.ax;
                f9 = (f4 * f11 - f5 * f13) / f16 - bone.ay;
            }
        }
        f15 += SpineUtils.atan2(f9, f10) * 57.295776f;
        if (bone.ascaleX < 0.0f) {
            f15 += 180.0f;
        }
        if (f15 > 180.0f) {
            f15 -= 360.0f;
        } else if (f15 < -180.0f) {
            f15 += 360.0f;
        }
        f8 = bone.ascaleX;
        f7 = bone.ascaleY;
        if (bl || bl2) {
            switch (bone.data.transformMode) {
                case noScale: 
                case noScaleOrReflection: {
                    f10 = f - bone.worldX;
                    f9 = f2 - bone.worldY;
                }
            }
            f6 = bone.data.length * f8;
            f5 = (float)Math.sqrt(f10 * f10 + f9 * f9);
            if (bl && f5 < f6 || bl2 && f5 > f6 && f6 > 1.0E-4f) {
                f4 = (f5 / f6 - 1.0f) * f3 + 1.0f;
                f8 *= f4;
                if (bl3) {
                    f7 *= f4;
                }
            }
        }
        bone.updateWorldTransform(bone.ax, bone.ay, bone.arotation + f15 * f3, f8, f7, bone.ashearX, bone.ashearY);
    }

    /*
     * Unable to fully structure code
     */
    public static void apply(Bone var0, Bone var1_1, float var2_2, float var3_3, int var4_4, boolean var5_5, boolean var6_6, float var7_7, float var8_8) {
        block33: {
            block32: {
                if (var0 == null) {
                    throw new IllegalArgumentException("parent cannot be null.");
                }
                if (var1_1 == null) {
                    throw new IllegalArgumentException("child cannot be null.");
                }
                var9_9 = var0.ax;
                var10_10 = var0.ay;
                var11_11 = var0.ascaleX;
                var12_12 = var0.ascaleY;
                var13_13 = var11_11;
                var14_14 = var12_12;
                var15_15 = var1_1.ascaleX;
                if (var11_11 < 0.0f) {
                    var11_11 = -var11_11;
                    var16_16 = 180;
                    var18_17 = -1;
                } else {
                    var16_16 = 0;
                    var18_17 = 1;
                }
                if (var12_12 < 0.0f) {
                    var12_12 = -var12_12;
                    var18_17 = -var18_17;
                }
                if (var15_15 < 0.0f) {
                    var15_15 = -var15_15;
                    var17_18 = 180;
                } else {
                    var17_18 = 0;
                }
                var19_19 = var1_1.ax;
                var23_20 = var0.a;
                var24_21 = var0.b;
                var25_22 = var0.c;
                var26_23 = var0.d;
                v0 = var27_24 = Math.abs(var11_11 - var12_12) <= 1.0E-4f;
                if (!var27_24 || var5_5) {
                    var20_25 = 0.0f;
                    var21_26 = var23_20 * var19_19 + var0.worldX;
                    var22_27 = var25_22 * var19_19 + var0.worldY;
                } else {
                    var20_25 = var1_1.ay;
                    var21_26 = var23_20 * var19_19 + var24_21 * var20_25 + var0.worldX;
                    var22_27 = var25_22 * var19_19 + var26_23 * var20_25 + var0.worldY;
                }
                var28_28 = var0.parent;
                var23_20 = var28_28.a;
                var24_21 = var28_28.b;
                var25_22 = var28_28.c;
                var26_23 = var28_28.d;
                var29_29 = 1.0f / (var23_20 * var26_23 - var24_21 * var25_22);
                var30_30 = var21_26 - var28_28.worldX;
                var31_31 = var22_27 - var28_28.worldY;
                var32_32 = (var30_30 * var26_23 - var31_31 * var24_21) * var29_29 - var9_9;
                var33_33 = (var31_31 * var23_20 - var30_30 * var25_22) * var29_29 - var10_10;
                var34_34 = (float)Math.sqrt(var32_32 * var32_32 + var33_33 * var33_33);
                var35_35 = var1_1.data.length * var15_15;
                if (var34_34 < 1.0E-4f) {
                    IkConstraint.apply(var0, var2_2, var3_3, false, var5_5, false, var8_8);
                    var1_1.updateWorldTransform(var19_19, var20_25, 0.0f, var1_1.ascaleX, var1_1.ascaleY, var1_1.ashearX, var1_1.ashearY);
                    return;
                }
                var30_30 = var2_2 - var28_28.worldX;
                var31_31 = var3_3 - var28_28.worldY;
                var38_36 = (var30_30 * var26_23 - var31_31 * var24_21) * var29_29 - var9_9;
                var39_37 = (var31_31 * var23_20 - var30_30 * var25_22) * var29_29 - var10_10;
                var40_38 = var38_36 * var38_36 + var39_37 * var39_37;
                if (var7_7 != 0.0f) {
                    var7_7 *= var11_11 * (var15_15 + 1.0f) * 0.5f;
                    var41_39 = (float)Math.sqrt(var40_38);
                    var42_40 = var41_39 - var34_34 - var35_35 * var11_11 + var7_7;
                    if (var42_40 > 0.0f) {
                        var43_41 = Math.min(1.0f, var42_40 / (var7_7 * 2.0f)) - 1.0f;
                        var43_41 = (var42_40 - var7_7 * (1.0f - var43_41 * var43_41)) / var41_39;
                        var38_36 -= var43_41 * var38_36;
                        var39_37 -= var43_41 * var39_37;
                        var40_38 = var38_36 * var38_36 + var39_37 * var39_37;
                    }
                }
                if (!var27_24) break block32;
                if ((var41_39 = (var40_38 - var34_34 * var34_34 - (var35_35 *= var11_11) * var35_35) / (2.0f * var34_34 * var35_35)) < -1.0f) {
                    var41_39 = -1.0f;
                    var37_42 = 3.1415927f * (float)var4_4;
                } else if (var41_39 > 1.0f) {
                    var41_39 = 1.0f;
                    var37_42 = 0.0f;
                    if (var5_5) {
                        var23_20 = ((float)Math.sqrt(var40_38) / (var34_34 + var35_35) - 1.0f) * var8_8 + 1.0f;
                        var13_13 *= var23_20;
                        if (var6_6) {
                            var14_14 *= var23_20;
                        }
                    }
                } else {
                    var37_42 = (float)Math.acos(var41_39) * (float)var4_4;
                }
                var23_20 = var34_34 + var35_35 * var41_39;
                var24_21 = var35_35 * SpineUtils.sin(var37_42);
                var36_43 = SpineUtils.atan2(var39_37 * var23_20 - var38_36 * var24_21, var38_36 * var23_20 + var39_37 * var24_21);
                break block33;
            }
            var23_20 = var11_11 * var35_35;
            var24_21 = var12_12 * var35_35;
            var41_39 = var23_20 * var23_20;
            var42_40 = var24_21 * var24_21;
            var43_41 = SpineUtils.atan2(var39_37, var38_36);
            var44_44 = -2.0f * var42_40 * var34_34;
            var45_45 = var42_40 - var41_39;
            var25_22 = var42_40 * var34_34 * var34_34 + var41_39 * var40_38 - var41_39 * var42_40;
            var26_23 = var44_44 * var44_44 - 4.0f * var45_45 * var25_22;
            if (!(var26_23 >= 0.0f)) ** GOTO lbl-1000
            var46_46 = (float)Math.sqrt(var26_23);
            if (var44_44 < 0.0f) {
                var46_46 = -var46_46;
            }
            var46_46 = -(var44_44 + var46_46) * 0.5f;
            var47_47 = var46_46 / var45_45;
            var48_48 = var25_22 / var46_46;
            v1 = var49_49 = Math.abs(var47_47) < Math.abs(var48_48) ? var47_47 : var48_48;
            if (var49_49 * var49_49 <= var40_38) {
                var31_31 = (float)Math.sqrt(var40_38 - var49_49 * var49_49) * (float)var4_4;
                var36_43 = var43_41 - SpineUtils.atan2(var31_31, var49_49);
                var37_42 = SpineUtils.atan2(var31_31 / var12_12, (var49_49 - var34_34) / var11_11);
            } else lbl-1000:
            // 2 sources

            {
                var46_46 = 3.1415927f;
                var47_47 = var34_34 - var23_20;
                var48_48 = var47_47 * var47_47;
                var49_49 = 0.0f;
                var50_50 = 0.0f;
                var51_51 = var34_34 + var23_20;
                var52_52 = var51_51 * var51_51;
                var53_53 = 0.0f;
                var25_22 = -var23_20 * var34_34 / (var41_39 - var42_40);
                if (var25_22 >= -1.0f && var25_22 <= 1.0f) {
                    var30_30 = var23_20 * SpineUtils.cos(var25_22 = (float)Math.acos(var25_22)) + var34_34;
                    var26_23 = var30_30 * var30_30 + (var31_31 = var24_21 * SpineUtils.sin(var25_22)) * var31_31;
                    if (var26_23 < var48_48) {
                        var46_46 = var25_22;
                        var48_48 = var26_23;
                        var47_47 = var30_30;
                        var49_49 = var31_31;
                    }
                    if (var26_23 > var52_52) {
                        var50_50 = var25_22;
                        var52_52 = var26_23;
                        var51_51 = var30_30;
                        var53_53 = var31_31;
                    }
                }
                if (var40_38 <= (var48_48 + var52_52) * 0.5f) {
                    var36_43 = var43_41 - SpineUtils.atan2(var49_49 * (float)var4_4, var47_47);
                    var37_42 = var46_46 * (float)var4_4;
                } else {
                    var36_43 = var43_41 - SpineUtils.atan2(var53_53 * (float)var4_4, var51_51);
                    var37_42 = var50_50 * (float)var4_4;
                }
            }
        }
        var41_39 = SpineUtils.atan2(var20_25, var19_19) * (float)var18_17;
        var42_40 = var0.arotation;
        var36_43 = (var36_43 - var41_39) * 57.295776f + (float)var16_16 - var42_40;
        if (var36_43 > 180.0f) {
            var36_43 -= 360.0f;
        } else if (var36_43 < -180.0f) {
            var36_43 += 360.0f;
        }
        var0.updateWorldTransform(var9_9, var10_10, var42_40 + var36_43 * var8_8, var13_13, var14_14, 0.0f, 0.0f);
        var42_40 = var1_1.arotation;
        var37_42 = ((var37_42 + var41_39) * 57.295776f - var1_1.ashearX) * (float)var18_17 + (float)var17_18 - var42_40;
        if (var37_42 > 180.0f) {
            var37_42 -= 360.0f;
        } else if (var37_42 < -180.0f) {
            var37_42 += 360.0f;
        }
        var1_1.updateWorldTransform(var19_19, var20_25, var42_40 + var37_42 * var8_8, var1_1.ascaleX, var1_1.ascaleY, var1_1.ashearX, var1_1.ashearY);
    }
}

