/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.StateTracker;

public final class GL20 {
    static native void nglShaderSource(int var0, int var1, long var2, int var4, long var5);

    public static void glShaderSource(int shader, CharSequence string) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glShaderSource;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL20.nglShaderSource(shader, 1, APIUtil.getBuffer(caps, string), string.length(), function_pointer);
    }

    public static int glCreateShader(int type) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glCreateShader;
        BufferChecks.checkFunctionAddress(function_pointer);
        int __result = GL20.nglCreateShader(type, function_pointer);
        return __result;
    }

    static native int nglCreateShader(int var0, long var1);

    public static void glCompileShader(int shader) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glCompileShader;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL20.nglCompileShader(shader, function_pointer);
    }

    static native void nglCompileShader(int var0, long var1);

    public static void glDeleteShader(int shader) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glDeleteShader;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL20.nglDeleteShader(shader, function_pointer);
    }

    static native void nglDeleteShader(int var0, long var1);

    public static int glCreateProgram() {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glCreateProgram;
        BufferChecks.checkFunctionAddress(function_pointer);
        int __result = GL20.nglCreateProgram(function_pointer);
        return __result;
    }

    static native int nglCreateProgram(long var0);

    public static void glAttachShader(int program, int shader) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glAttachShader;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL20.nglAttachShader(program, shader, function_pointer);
    }

    static native void nglAttachShader(int var0, int var1, long var2);

    public static void glLinkProgram(int program) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glLinkProgram;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL20.nglLinkProgram(program, function_pointer);
    }

    static native void nglLinkProgram(int var0, long var1);

    public static void glUseProgram(int program) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glUseProgram;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL20.nglUseProgram(program, function_pointer);
    }

    static native void nglUseProgram(int var0, long var1);

    public static void glDeleteProgram(int program) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glDeleteProgram;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL20.nglDeleteProgram(program, function_pointer);
    }

    static native void nglDeleteProgram(int var0, long var1);

    public static void glUniform1f(int location, float v0) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glUniform1f;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL20.nglUniform1f(location, v0, function_pointer);
    }

    static native void nglUniform1f(int var0, float var1, long var2);

    public static void glUniform1i(int location, int v0) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glUniform1i;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL20.nglUniform1i(location, v0, function_pointer);
    }

    static native void nglUniform1i(int var0, int var1, long var2);

    public static void glUniformMatrix4(int location, boolean transpose, FloatBuffer matrices) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glUniformMatrix4fv;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(matrices);
        GL20.nglUniformMatrix4fv(location, matrices.remaining() >> 4, transpose, MemoryUtil.getAddress(matrices), function_pointer);
    }

    static native void nglUniformMatrix4fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glGetShader(int shader, int pname, IntBuffer params) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetShaderiv;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(params);
        GL20.nglGetShaderiv(shader, pname, MemoryUtil.getAddress(params), function_pointer);
    }

    static native void nglGetShaderiv(int var0, int var1, long var2, long var4);

    public static void glGetProgram(int program, int pname, IntBuffer params) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetProgramiv;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(params);
        GL20.nglGetProgramiv(program, pname, MemoryUtil.getAddress(params), function_pointer);
    }

    static native void nglGetProgramiv(int var0, int var1, long var2, long var4);

    public static void glGetShaderInfoLog(int shader, IntBuffer length, ByteBuffer infoLog) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetShaderInfoLog;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(infoLog);
        GL20.nglGetShaderInfoLog(shader, infoLog.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(infoLog), function_pointer);
    }

    static native void nglGetShaderInfoLog(int var0, int var1, long var2, long var4, long var6);

    public static void glGetProgramInfoLog(int program, IntBuffer length, ByteBuffer infoLog) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetProgramInfoLog;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(infoLog);
        GL20.nglGetProgramInfoLog(program, infoLog.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(infoLog), function_pointer);
    }

    static native void nglGetProgramInfoLog(int var0, int var1, long var2, long var4, long var6);

    static native int nglGetUniformLocation(int var0, long var1, long var3);

    public static int glGetUniformLocation(int program, CharSequence name) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetUniformLocation;
        BufferChecks.checkFunctionAddress(function_pointer);
        int __result = GL20.nglGetUniformLocation(program, APIUtil.getBufferNT(caps, name), function_pointer);
        return __result;
    }

    static native void nglGetActiveUniform(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public static String glGetActiveUniform(int program, int index, int maxLength, IntBuffer sizeType) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetActiveUniform;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkBuffer(sizeType, 2);
        IntBuffer name_length = APIUtil.getLengths(caps);
        ByteBuffer name = APIUtil.getBufferByte(caps, maxLength);
        GL20.nglGetActiveUniform(program, index, maxLength, MemoryUtil.getAddress0(name_length), MemoryUtil.getAddress(sizeType), MemoryUtil.getAddress(sizeType, sizeType.position() + 1), MemoryUtil.getAddress(name), function_pointer);
        name.limit(name_length.get(0));
        return APIUtil.getString(caps, name);
    }

    public static void glVertexAttribPointer(int index, int size, boolean normalized, int stride, FloatBuffer buffer) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        GLChecks.ensureArrayVBOdisabled(caps);
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)caps).glVertexAttribPointer_buffer[index] = buffer;
        }
        GL20.nglVertexAttribPointer(index, size, 5126, normalized, stride, MemoryUtil.getAddress(buffer), function_pointer);
    }

    public static void glVertexAttribPointer(int index, int size, boolean unsigned, boolean normalized, int stride, ByteBuffer buffer) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        GLChecks.ensureArrayVBOdisabled(caps);
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)caps).glVertexAttribPointer_buffer[index] = buffer;
        }
        GL20.nglVertexAttribPointer(index, size, unsigned ? 5121 : 5120, normalized, stride, MemoryUtil.getAddress(buffer), function_pointer);
    }

    public static void glVertexAttribPointer(int index, int size, boolean unsigned, boolean normalized, int stride, ShortBuffer buffer) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        GLChecks.ensureArrayVBOdisabled(caps);
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)caps).glVertexAttribPointer_buffer[index] = buffer;
        }
        GL20.nglVertexAttribPointer(index, size, unsigned ? 5123 : 5122, normalized, stride, MemoryUtil.getAddress(buffer), function_pointer);
    }

    static native void nglVertexAttribPointer(int var0, int var1, int var2, boolean var3, int var4, long var5, long var7);

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long buffer_buffer_offset) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        GLChecks.ensureArrayVBOenabled(caps);
        GL20.nglVertexAttribPointerBO(index, size, type, normalized, stride, buffer_buffer_offset, function_pointer);
    }

    static native void nglVertexAttribPointerBO(int var0, int var1, int var2, boolean var3, int var4, long var5, long var7);

    public static void glEnableVertexAttribArray(int index) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glEnableVertexAttribArray;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL20.nglEnableVertexAttribArray(index, function_pointer);
    }

    static native void nglEnableVertexAttribArray(int var0, long var1);

    public static void glDisableVertexAttribArray(int index) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glDisableVertexAttribArray;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL20.nglDisableVertexAttribArray(index, function_pointer);
    }

    static native void nglDisableVertexAttribArray(int var0, long var1);

    static native void nglGetActiveAttrib(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public static String glGetActiveAttrib(int program, int index, int maxLength, IntBuffer sizeType) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetActiveAttrib;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkBuffer(sizeType, 2);
        IntBuffer name_length = APIUtil.getLengths(caps);
        ByteBuffer name = APIUtil.getBufferByte(caps, maxLength);
        GL20.nglGetActiveAttrib(program, index, maxLength, MemoryUtil.getAddress0(name_length), MemoryUtil.getAddress(sizeType), MemoryUtil.getAddress(sizeType, sizeType.position() + 1), MemoryUtil.getAddress(name), function_pointer);
        name.limit(name_length.get(0));
        return APIUtil.getString(caps, name);
    }

    static native int nglGetAttribLocation(int var0, long var1, long var3);

    public static int glGetAttribLocation(int program, CharSequence name) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetAttribLocation;
        BufferChecks.checkFunctionAddress(function_pointer);
        int __result = GL20.nglGetAttribLocation(program, APIUtil.getBufferNT(caps, name), function_pointer);
        return __result;
    }
}

