/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.esotericsoftware.spine.attachments.VertexAttachment;

public class MeshAttachment
extends VertexAttachment {
    private TextureRegion region;
    private String path;
    private float[] regionUVs;
    private float[] uvs;
    private short[] triangles;
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private int hullLength;
    private MeshAttachment parentMesh;
    private short[] edges;
    private float width;
    private float height;

    public MeshAttachment(String string) {
        super(string);
    }

    public void setRegion(TextureRegion textureRegion) {
        if (textureRegion == null) {
            throw new IllegalArgumentException("region cannot be null.");
        }
        this.region = textureRegion;
    }

    public TextureRegion getRegion() {
        if (this.region == null) {
            throw new IllegalStateException("Region has not been set: " + this);
        }
        return this.region;
    }

    public void updateUVs() {
        float f;
        float f2;
        float f3;
        float f4;
        float[] fArray = this.regionUVs;
        if (this.uvs == null || this.uvs.length != fArray.length) {
            this.uvs = new float[fArray.length];
        }
        float[] fArray2 = this.uvs;
        int n = fArray2.length;
        if (this.region instanceof TextureAtlas.AtlasRegion) {
            f4 = this.region.getU();
            f3 = this.region.getV();
            TextureAtlas.AtlasRegion atlasRegion = (TextureAtlas.AtlasRegion)this.region;
            float f5 = atlasRegion.getTexture().getWidth();
            float f6 = atlasRegion.getTexture().getHeight();
            switch (atlasRegion.degrees) {
                case 90: {
                    f4 -= ((float)atlasRegion.originalHeight - atlasRegion.offsetY - (float)atlasRegion.packedWidth) / f5;
                    f3 -= ((float)atlasRegion.originalWidth - atlasRegion.offsetX - (float)atlasRegion.packedHeight) / f6;
                    float f7 = (float)atlasRegion.originalHeight / f5;
                    float f8 = (float)atlasRegion.originalWidth / f6;
                    for (int i = 0; i < n; i += 2) {
                        fArray2[i] = f4 + fArray[i + 1] * f7;
                        fArray2[i + 1] = f3 + (1.0f - fArray[i]) * f8;
                    }
                    return;
                }
                case 180: {
                    f4 -= ((float)atlasRegion.originalWidth - atlasRegion.offsetX - (float)atlasRegion.packedWidth) / f5;
                    f3 -= atlasRegion.offsetY / f6;
                    float f9 = (float)atlasRegion.originalWidth / f5;
                    float f10 = (float)atlasRegion.originalHeight / f6;
                    for (int i = 0; i < n; i += 2) {
                        fArray2[i] = f4 + (1.0f - fArray[i]) * f9;
                        fArray2[i + 1] = f3 + (1.0f - fArray[i + 1]) * f10;
                    }
                    return;
                }
                case 270: {
                    f4 -= atlasRegion.offsetY / f5;
                    f3 -= atlasRegion.offsetX / f6;
                    float f11 = (float)atlasRegion.originalHeight / f5;
                    float f12 = (float)atlasRegion.originalWidth / f6;
                    for (int i = 0; i < n; i += 2) {
                        fArray2[i] = f4 + (1.0f - fArray[i + 1]) * f11;
                        fArray2[i + 1] = f3 + fArray[i] * f12;
                    }
                    return;
                }
            }
            f4 -= atlasRegion.offsetX / f5;
            f3 -= ((float)atlasRegion.originalHeight - atlasRegion.offsetY - (float)atlasRegion.packedHeight) / f6;
            f2 = (float)atlasRegion.originalWidth / f5;
            f = (float)atlasRegion.originalHeight / f6;
        } else if (this.region == null) {
            f3 = 0.0f;
            f4 = 0.0f;
            f = 1.0f;
            f2 = 1.0f;
        } else {
            f4 = this.region.getU();
            f3 = this.region.getV();
            f2 = this.region.getU2() - f4;
            f = this.region.getV2() - f3;
        }
        for (int i = 0; i < n; i += 2) {
            fArray2[i] = f4 + fArray[i] * f2;
            fArray2[i + 1] = f3 + fArray[i + 1] * f;
        }
    }

    public short[] getTriangles() {
        return this.triangles;
    }

    public void setTriangles(short[] sArray) {
        this.triangles = sArray;
    }

    public void setRegionUVs(float[] fArray) {
        this.regionUVs = fArray;
    }

    public float[] getUVs() {
        return this.uvs;
    }

    public Color getColor() {
        return this.color;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public int getHullLength() {
        return this.hullLength;
    }

    public void setHullLength(int n) {
        this.hullLength = n;
    }

    public void setEdges(short[] sArray) {
        this.edges = sArray;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public void setParentMesh(MeshAttachment meshAttachment) {
        this.parentMesh = meshAttachment;
        if (meshAttachment != null) {
            this.bones = meshAttachment.bones;
            this.vertices = meshAttachment.vertices;
            this.regionUVs = meshAttachment.regionUVs;
            this.triangles = meshAttachment.triangles;
            this.hullLength = meshAttachment.hullLength;
            this.worldVerticesLength = meshAttachment.worldVerticesLength;
            this.edges = meshAttachment.edges;
            this.width = meshAttachment.width;
            this.height = meshAttachment.height;
        }
    }
}

