/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.utils.SpineUtils;

public class IkConstraint
implements Updatable {
    final IkConstraintData data;
    final Array<Bone> bones;
    Bone target;
    int bendDirection;
    boolean compress;
    boolean stretch;
    float mix = 1.0f;
    float softness;
    boolean active;

    public IkConstraint(IkConstraintData ikConstraintData, Skeleton skeleton) {
        if (ikConstraintData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = ikConstraintData;
        this.mix = ikConstraintData.mix;
        this.softness = ikConstraintData.softness;
        this.bendDirection = ikConstraintData.bendDirection;
        this.compress = ikConstraintData.compress;
        this.stretch = ikConstraintData.stretch;
        this.bones = new Array(ikConstraintData.bones.size);
        for (BoneData boneData : ikConstraintData.bones) {
            this.bones.add(skeleton.findBone(boneData.name));
        }
        this.target = skeleton.findBone(ikConstraintData.target.name);
    }

    public IkConstraint(IkConstraint ikConstraint, Skeleton skeleton) {
        if (ikConstraint == null) {
            throw new IllegalArgumentException("constraint cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = ikConstraint.data;
        this.bones = new Array(ikConstraint.bones.size);
        for (Bone bone : ikConstraint.bones) {
            this.bones.add(skeleton.bones.get(bone.data.index));
        }
        this.target = skeleton.bones.get(ikConstraint.target.data.index);
        this.mix = ikConstraint.mix;
        this.softness = ikConstraint.softness;
        this.bendDirection = ikConstraint.bendDirection;
        this.compress = ikConstraint.compress;
        this.stretch = ikConstraint.stretch;
    }

    @Override
    public void update() {
        Bone bone = this.target;
        Array<Bone> array = this.bones;
        switch (array.size) {
            case 1: {
                IkConstraint.apply(array.first(), bone.worldX, bone.worldY, this.compress, this.stretch, this.data.uniform, this.mix);
                break;
            }
            case 2: {
                IkConstraint.apply(array.first(), array.get(1), bone.worldX, bone.worldY, this.bendDirection, this.stretch, this.softness, this.mix);
            }
        }
    }

    public String toString() {
        return this.data.name;
    }

    public static void apply(Bone bone, float f, float f2, boolean bl, boolean bl2, boolean bl3, float f3) {
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        if (bone == null) {
            throw new IllegalArgumentException("bone cannot be null.");
        }
        if (!bone.appliedValid) {
            bone.updateAppliedTransform();
        }
        Bone bone2 = bone.parent;
        float f11 = bone2.a;
        float f12 = bone2.b;
        float f13 = bone2.c;
        float f14 = bone2.d;
        float f15 = -bone.ashearX - bone.arotation;
        switch (bone.data.transformMode) {
            case onlyTranslation: {
                f10 = f - bone.worldX;
                f9 = f2 - bone.worldY;
                break;
            }
            case noRotationOrReflection: {
                f8 = Math.abs(f11 * f14 - f12 * f13) / (f11 * f11 + f13 * f13);
                f7 = f11 / bone.skeleton.scaleX;
                f6 = f13 / bone.skeleton.scaleY;
                f12 = -f6 * f8 * bone.skeleton.scaleX;
                f14 = f7 * f8 * bone.skeleton.scaleY;
                f15 += SpineUtils.atan2(f6, f7) * 57.295776f;
            }
            default: {
                f5 = f - bone2.worldX;
                f4 = f2 - bone2.worldY;
                float f16 = f11 * f14 - f12 * f13;
                f10 = (f5 * f14 - f4 * f12) / f16 - bone.ax;
                f9 = (f4 * f11 - f5 * f13) / f16 - bone.ay;
            }
        }
        f15 += SpineUtils.atan2(f9, f10) * 57.295776f;
        if (bone.ascaleX < 0.0f) {
            f15 += 180.0f;
        }
        if (f15 > 180.0f) {
            f15 -= 360.0f;
        } else if (f15 < -180.0f) {
            f15 += 360.0f;
        }
        f8 = bone.ascaleX;
        f7 = bone.ascaleY;
        if (bl || bl2) {
            switch (bone.data.transformMode) {
                case noScale: 
                case noScaleOrReflection: {
                    f10 = f - bone.worldX;
                    f9 = f2 - bone.worldY;
                }
            }
            f6 = bone.data.length * f8;
            f5 = (float)Math.sqrt(f10 * f10 + f9 * f9);
            if (bl && f5 < f6 || bl2 && f5 > f6 && f6 > 1.0E-4f) {
                f4 = (f5 / f6 - 1.0f) * f3 + 1.0f;
                f8 *= f4;
                if (bl3) {
                    f7 *= f4;
                }
            }
        }
        bone.updateWorldTransform(bone.ax, bone.ay, bone.arotation + f15 * f3, f8, f7, bone.ashearX, bone.ashearY);
    }

    /*
     * Unable to fully structure code
     */
    public static void apply(Bone var0, Bone var1_1, float var2_2, float var3_3, int var4_4, boolean var5_5, float var6_6, float var7_7) {
        block34: {
            block33: {
                if (var0 == null) {
                    throw new IllegalArgumentException("parent cannot be null.");
                }
                if (var1_1 == null) {
                    throw new IllegalArgumentException("child cannot be null.");
                }
                if (var7_7 == 0.0f) {
                    var1_1.updateWorldTransform();
                    return;
                }
                if (!var0.appliedValid) {
                    var0.updateAppliedTransform();
                }
                if (!var1_1.appliedValid) {
                    var1_1.updateAppliedTransform();
                }
                var8_8 = var0.ax;
                var9_9 = var0.ay;
                var11_11 = var10_10 = var0.ascaleX;
                var12_12 = var0.ascaleY;
                var13_13 = var1_1.ascaleX;
                if (var10_10 < 0.0f) {
                    var10_10 = -var10_10;
                    var14_14 = 180;
                    var16_15 = -1;
                } else {
                    var14_14 = 0;
                    var16_15 = 1;
                }
                if (var12_12 < 0.0f) {
                    var12_12 = -var12_12;
                    var16_15 = -var16_15;
                }
                if (var13_13 < 0.0f) {
                    var13_13 = -var13_13;
                    var15_16 = 180;
                } else {
                    var15_16 = 0;
                }
                var17_17 = var1_1.ax;
                var21_18 = var0.a;
                var22_19 = var0.b;
                var23_20 = var0.c;
                var24_21 = var0.d;
                v0 = var25_22 = Math.abs(var10_10 - var12_12) <= 1.0E-4f;
                if (!var25_22) {
                    var18_23 = 0.0f;
                    var19_24 = var21_18 * var17_17 + var0.worldX;
                    var20_25 = var23_20 * var17_17 + var0.worldY;
                } else {
                    var18_23 = var1_1.ay;
                    var19_24 = var21_18 * var17_17 + var22_19 * var18_23 + var0.worldX;
                    var20_25 = var23_20 * var17_17 + var24_21 * var18_23 + var0.worldY;
                }
                var26_26 = var0.parent;
                var21_18 = var26_26.a;
                var22_19 = var26_26.b;
                var23_20 = var26_26.c;
                var24_21 = var26_26.d;
                var27_27 = 1.0f / (var21_18 * var24_21 - var22_19 * var23_20);
                var28_28 = var19_24 - var26_26.worldX;
                var29_29 = var20_25 - var26_26.worldY;
                var30_30 = (var28_28 * var24_21 - var29_29 * var22_19) * var27_27 - var8_8;
                var31_31 = (var29_29 * var21_18 - var28_28 * var23_20) * var27_27 - var9_9;
                var32_32 = (float)Math.sqrt(var30_30 * var30_30 + var31_31 * var31_31);
                var33_33 = var1_1.data.length * var13_13;
                if (var32_32 < 1.0E-4f) {
                    IkConstraint.apply(var0, var2_2, var3_3, false, var5_5, false, var7_7);
                    var1_1.updateWorldTransform(var17_17, var18_23, 0.0f, var1_1.ascaleX, var1_1.ascaleY, var1_1.ashearX, var1_1.ashearY);
                    return;
                }
                var28_28 = var2_2 - var26_26.worldX;
                var29_29 = var3_3 - var26_26.worldY;
                var36_34 = (var28_28 * var24_21 - var29_29 * var22_19) * var27_27 - var8_8;
                var37_35 = (var29_29 * var21_18 - var28_28 * var23_20) * var27_27 - var9_9;
                var38_36 = var36_34 * var36_34 + var37_35 * var37_35;
                if (var6_6 != 0.0f) {
                    var6_6 *= var10_10 * (var13_13 + 1.0f) / 2.0f;
                    var39_37 = (float)Math.sqrt(var38_36);
                    var40_38 = var39_37 - var32_32 - var33_33 * var10_10 + var6_6;
                    if (var40_38 > 0.0f) {
                        var41_39 = Math.min(1.0f, var40_38 / (var6_6 * 2.0f)) - 1.0f;
                        var41_39 = (var40_38 - var6_6 * (1.0f - var41_39 * var41_39)) / var39_37;
                        var36_34 -= var41_39 * var36_34;
                        var37_35 -= var41_39 * var37_35;
                        var38_36 = var36_34 * var36_34 + var37_35 * var37_35;
                    }
                }
                if (!var25_22) break block33;
                if ((var39_37 = (var38_36 - var32_32 * var32_32 - (var33_33 *= var10_10) * var33_33) / (2.0f * var32_32 * var33_33)) < -1.0f) {
                    var39_37 = -1.0f;
                } else if (var39_37 > 1.0f) {
                    var39_37 = 1.0f;
                    if (var5_5) {
                        var11_11 *= ((float)Math.sqrt(var38_36) / (var32_32 + var33_33) - 1.0f) * var7_7 + 1.0f;
                    }
                }
                var35_40 = (float)Math.acos(var39_37) * (float)var4_4;
                var21_18 = var32_32 + var33_33 * var39_37;
                var22_19 = var33_33 * SpineUtils.sin(var35_40);
                var34_41 = SpineUtils.atan2(var37_35 * var21_18 - var36_34 * var22_19, var36_34 * var21_18 + var37_35 * var22_19);
                break block34;
            }
            var21_18 = var10_10 * var33_33;
            var22_19 = var12_12 * var33_33;
            var39_37 = var21_18 * var21_18;
            var40_38 = var22_19 * var22_19;
            var41_39 = SpineUtils.atan2(var37_35, var36_34);
            var42_42 = -2.0f * var40_38 * var32_32;
            var43_43 = var40_38 - var39_37;
            var23_20 = var40_38 * var32_32 * var32_32 + var39_37 * var38_36 - var39_37 * var40_38;
            var24_21 = var42_42 * var42_42 - 4.0f * var43_43 * var23_20;
            if (!(var24_21 >= 0.0f)) ** GOTO lbl-1000
            var44_44 = (float)Math.sqrt(var24_21);
            if (var42_42 < 0.0f) {
                var44_44 = -var44_44;
            }
            var44_44 = -(var42_42 + var44_44) / 2.0f;
            var45_45 = var44_44 / var43_43;
            var46_46 = var23_20 / var44_44;
            v1 = var47_47 = Math.abs(var45_45) < Math.abs(var46_46) ? var45_45 : var46_46;
            if (var47_47 * var47_47 <= var38_36) {
                var29_29 = (float)Math.sqrt(var38_36 - var47_47 * var47_47) * (float)var4_4;
                var34_41 = var41_39 - SpineUtils.atan2(var29_29, var47_47);
                var35_40 = SpineUtils.atan2(var29_29 / var12_12, (var47_47 - var32_32) / var10_10);
            } else lbl-1000:
            // 2 sources

            {
                var44_44 = 3.1415927f;
                var45_45 = var32_32 - var21_18;
                var46_46 = var45_45 * var45_45;
                var47_47 = 0.0f;
                var48_48 = 0.0f;
                var49_49 = var32_32 + var21_18;
                var50_50 = var49_49 * var49_49;
                var51_51 = 0.0f;
                var23_20 = -var21_18 * var32_32 / (var39_37 - var40_38);
                if (var23_20 >= -1.0f && var23_20 <= 1.0f) {
                    var28_28 = var21_18 * SpineUtils.cos(var23_20 = (float)Math.acos(var23_20)) + var32_32;
                    var24_21 = var28_28 * var28_28 + (var29_29 = var22_19 * SpineUtils.sin(var23_20)) * var29_29;
                    if (var24_21 < var46_46) {
                        var44_44 = var23_20;
                        var46_46 = var24_21;
                        var45_45 = var28_28;
                        var47_47 = var29_29;
                    }
                    if (var24_21 > var50_50) {
                        var48_48 = var23_20;
                        var50_50 = var24_21;
                        var49_49 = var28_28;
                        var51_51 = var29_29;
                    }
                }
                if (var38_36 <= (var46_46 + var50_50) / 2.0f) {
                    var34_41 = var41_39 - SpineUtils.atan2(var47_47 * (float)var4_4, var45_45);
                    var35_40 = var44_44 * (float)var4_4;
                } else {
                    var34_41 = var41_39 - SpineUtils.atan2(var51_51 * (float)var4_4, var49_49);
                    var35_40 = var48_48 * (float)var4_4;
                }
            }
        }
        var39_37 = SpineUtils.atan2(var18_23, var17_17) * (float)var16_15;
        var40_38 = var0.arotation;
        var34_41 = (var34_41 - var39_37) * 57.295776f + (float)var14_14 - var40_38;
        if (var34_41 > 180.0f) {
            var34_41 -= 360.0f;
        } else if (var34_41 < -180.0f) {
            var34_41 += 360.0f;
        }
        var0.updateWorldTransform(var8_8, var9_9, var40_38 + var34_41 * var7_7, var11_11, var0.ascaleY, 0.0f, 0.0f);
        var40_38 = var1_1.arotation;
        var35_40 = ((var35_40 + var39_37) * 57.295776f - var1_1.ashearX) * (float)var16_15 + (float)var15_16 - var40_38;
        if (var35_40 > 180.0f) {
            var35_40 -= 360.0f;
        } else if (var35_40 < -180.0f) {
            var35_40 += 360.0f;
        }
        var1_1.updateWorldTransform(var17_17, var18_23, var40_38 + var35_40 * var7_7, var1_1.ascaleX, var1_1.ascaleY, var1_1.ashearX, var1_1.ashearY);
    }
}

