/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import java.util.Arrays;

public class StringBuilder
implements Appendable,
CharSequence {
    public char[] chars;
    public int length;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static int numChars(int value, int radix) {
        int result;
        int n = result = value < 0 ? 2 : 1;
        while ((value /= radix) != 0) {
            ++result;
        }
        return result;
    }

    public static int numChars(long value, int radix) {
        int result;
        int n = result = value < 0L ? 2 : 1;
        while ((value /= (long)radix) != 0L) {
            ++result;
        }
        return result;
    }

    public StringBuilder() {
        this.chars = new char[16];
    }

    public StringBuilder(int capacity) {
        if (capacity < 0) {
            throw new NegativeArraySizeException();
        }
        this.chars = new char[capacity];
    }

    public StringBuilder(String string) {
        this.length = string.length();
        this.chars = new char[this.length + 16];
        string.getChars(0, this.length, this.chars, 0);
    }

    private void enlargeBuffer(int min) {
        int newSize = (this.chars.length >> 1) + this.chars.length + 2;
        char[] newData = new char[min > newSize ? min : newSize];
        System.arraycopy(this.chars, 0, newData, 0, this.length);
        this.chars = newData;
    }

    final void appendNull() {
        int newSize = this.length + 4;
        if (newSize > this.chars.length) {
            this.enlargeBuffer(newSize);
        }
        this.chars[this.length++] = 110;
        this.chars[this.length++] = 117;
        this.chars[this.length++] = 108;
        this.chars[this.length++] = 108;
    }

    final void append0(char[] value) {
        int newSize = this.length + value.length;
        if (newSize > this.chars.length) {
            this.enlargeBuffer(newSize);
        }
        System.arraycopy(value, 0, this.chars, this.length, value.length);
        this.length = newSize;
    }

    final void append0(char[] value, int offset, int length) {
        if (offset > value.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset out of bounds: " + offset);
        }
        if (length < 0 || value.length - offset < length) {
            throw new ArrayIndexOutOfBoundsException("Length out of bounds: " + length);
        }
        int newSize = this.length + length;
        if (newSize > this.chars.length) {
            this.enlargeBuffer(newSize);
        }
        System.arraycopy(value, offset, this.chars, this.length, length);
        this.length = newSize;
    }

    final void append0(char ch) {
        if (this.length == this.chars.length) {
            this.enlargeBuffer(this.length + 1);
        }
        this.chars[this.length++] = ch;
    }

    final void append0(String string) {
        if (string == null) {
            this.appendNull();
            return;
        }
        int adding = string.length();
        int newSize = this.length + adding;
        if (newSize > this.chars.length) {
            this.enlargeBuffer(newSize);
        }
        string.getChars(0, adding, this.chars, this.length);
        this.length = newSize;
    }

    final void append0(CharSequence s, int start, int end) {
        if (s == null) {
            s = "null";
        }
        if (start < 0 || end < 0 || start > end || end > s.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.append0(s.subSequence(start, end).toString());
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.chars[index];
    }

    final void insert0(int index, String string) {
        if (0 <= index && index <= this.length) {
            int min;
            if (string == null) {
                string = "null";
            }
            if ((min = string.length()) != 0) {
                this.move(min, index);
                string.getChars(0, min, this.chars, index);
                this.length += min;
            }
        } else {
            throw new StringIndexOutOfBoundsException(index);
        }
    }

    @Override
    public int length() {
        return this.length;
    }

    private void move(int size, int index) {
        if (this.chars.length - this.length >= size) {
            System.arraycopy(this.chars, index, this.chars, index + size, this.length - index);
            return;
        }
        int a = this.length + size;
        int b = (this.chars.length << 1) + 2;
        int newSize = a > b ? a : b;
        char[] newData = new char[newSize];
        System.arraycopy(this.chars, 0, newData, 0, index);
        System.arraycopy(this.chars, index, newData, index + size, this.length - index);
        this.chars = newData;
    }

    final void replace0(int start, int end, String string) {
        if (start >= 0) {
            if (end > this.length) {
                end = this.length;
            }
            if (end > start) {
                int stringLength = string.length();
                int diff = end - start - stringLength;
                if (diff > 0) {
                    System.arraycopy(this.chars, end, this.chars, start + stringLength, this.length - end);
                } else if (diff < 0) {
                    this.move(-diff, end);
                }
                string.getChars(0, stringLength, this.chars, start);
                this.length -= diff;
                return;
            }
            if (start == end) {
                if (string == null) {
                    throw new NullPointerException();
                }
                this.insert0(start, string);
                return;
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        if (newLength > this.chars.length) {
            this.enlargeBuffer(newLength);
        } else if (this.length < newLength) {
            Arrays.fill(this.chars, this.length, newLength, '\u0000');
        }
        this.length = newLength;
    }

    public String substring(int start, int end) {
        if (0 <= start && start <= end && end <= this.length) {
            if (start == end) {
                return "";
            }
            return new String(this.chars, start, end - start);
        }
        throw new StringIndexOutOfBoundsException();
    }

    @Override
    public String toString() {
        if (this.length == 0) {
            return "";
        }
        return new String(this.chars, 0, this.length);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String subString, int start) {
        int subCount;
        if (start < 0) {
            start = 0;
        }
        if ((subCount = subString.length()) == 0) {
            return start < this.length || start == 0 ? start : this.length;
        }
        int maxIndex = this.length - subCount;
        if (start > maxIndex) {
            return -1;
        }
        char firstChar = subString.charAt(0);
        while (true) {
            int i;
            boolean found = false;
            for (i = start; i <= maxIndex; ++i) {
                if (this.chars[i] != firstChar) continue;
                found = true;
                break;
            }
            if (!found) {
                return -1;
            }
            int o1 = i;
            int o2 = 0;
            while (++o2 < subCount && this.chars[++o1] == subString.charAt(o2)) {
            }
            if (o2 == subCount) {
                return i;
            }
            start = i + 1;
        }
    }

    public StringBuilder append(boolean b) {
        this.append0(b ? "true" : "false");
        return this;
    }

    @Override
    public StringBuilder append(char c) {
        this.append0(c);
        return this;
    }

    public StringBuilder append(int value) {
        return this.append(value, 0);
    }

    public StringBuilder append(int value, int minLength) {
        return this.append(value, minLength, '0');
    }

    public StringBuilder append(int value, int minLength, char prefix) {
        if (value == Integer.MIN_VALUE) {
            this.append0("-2147483648");
            return this;
        }
        if (value < 0) {
            this.append0('-');
            value = -value;
        }
        if (minLength > 1) {
            for (int j = minLength - StringBuilder.numChars(value, 10); j > 0; --j) {
                this.append(prefix);
            }
        }
        if (value >= 10000) {
            if (value >= 1000000000) {
                this.append0(digits[(int)((long)value % 10000000000L / 1000000000L)]);
            }
            if (value >= 100000000) {
                this.append0(digits[value % 1000000000 / 100000000]);
            }
            if (value >= 10000000) {
                this.append0(digits[value % 100000000 / 10000000]);
            }
            if (value >= 1000000) {
                this.append0(digits[value % 10000000 / 1000000]);
            }
            if (value >= 100000) {
                this.append0(digits[value % 1000000 / 100000]);
            }
            this.append0(digits[value % 100000 / 10000]);
        }
        if (value >= 1000) {
            this.append0(digits[value % 10000 / 1000]);
        }
        if (value >= 100) {
            this.append0(digits[value % 1000 / 100]);
        }
        if (value >= 10) {
            this.append0(digits[value % 100 / 10]);
        }
        this.append0(digits[value % 10]);
        return this;
    }

    public StringBuilder append(long value) {
        return this.append(value, 0);
    }

    public StringBuilder append(long value, int minLength) {
        return this.append(value, minLength, '0');
    }

    public StringBuilder append(long value, int minLength, char prefix) {
        if (value == Long.MIN_VALUE) {
            this.append0("-9223372036854775808");
            return this;
        }
        if (value < 0L) {
            this.append0('-');
            value = -value;
        }
        if (minLength > 1) {
            for (int j = minLength - StringBuilder.numChars(value, 10); j > 0; --j) {
                this.append(prefix);
            }
        }
        if (value >= 10000L) {
            if (value >= 1000000000000000000L) {
                this.append0(digits[(int)((double)value % 1.0E19 / 1.0E18)]);
            }
            if (value >= 100000000000000000L) {
                this.append0(digits[(int)(value % 1000000000000000000L / 100000000000000000L)]);
            }
            if (value >= 10000000000000000L) {
                this.append0(digits[(int)(value % 100000000000000000L / 10000000000000000L)]);
            }
            if (value >= 1000000000000000L) {
                this.append0(digits[(int)(value % 10000000000000000L / 1000000000000000L)]);
            }
            if (value >= 100000000000000L) {
                this.append0(digits[(int)(value % 1000000000000000L / 100000000000000L)]);
            }
            if (value >= 10000000000000L) {
                this.append0(digits[(int)(value % 100000000000000L / 10000000000000L)]);
            }
            if (value >= 1000000000000L) {
                this.append0(digits[(int)(value % 10000000000000L / 1000000000000L)]);
            }
            if (value >= 100000000000L) {
                this.append0(digits[(int)(value % 1000000000000L / 100000000000L)]);
            }
            if (value >= 10000000000L) {
                this.append0(digits[(int)(value % 100000000000L / 10000000000L)]);
            }
            if (value >= 1000000000L) {
                this.append0(digits[(int)(value % 10000000000L / 1000000000L)]);
            }
            if (value >= 100000000L) {
                this.append0(digits[(int)(value % 1000000000L / 100000000L)]);
            }
            if (value >= 10000000L) {
                this.append0(digits[(int)(value % 100000000L / 10000000L)]);
            }
            if (value >= 1000000L) {
                this.append0(digits[(int)(value % 10000000L / 1000000L)]);
            }
            if (value >= 100000L) {
                this.append0(digits[(int)(value % 1000000L / 100000L)]);
            }
            this.append0(digits[(int)(value % 100000L / 10000L)]);
        }
        if (value >= 1000L) {
            this.append0(digits[(int)(value % 10000L / 1000L)]);
        }
        if (value >= 100L) {
            this.append0(digits[(int)(value % 1000L / 100L)]);
        }
        if (value >= 10L) {
            this.append0(digits[(int)(value % 100L / 10L)]);
        }
        this.append0(digits[(int)(value % 10L)]);
        return this;
    }

    public StringBuilder append(float f) {
        this.append0(Float.toString(f));
        return this;
    }

    public StringBuilder append(double d) {
        this.append0(Double.toString(d));
        return this;
    }

    public StringBuilder append(Object obj) {
        if (obj == null) {
            this.appendNull();
        } else {
            this.append0(obj.toString());
        }
        return this;
    }

    public StringBuilder append(String str) {
        this.append0(str);
        return this;
    }

    public StringBuilder append(char[] ch) {
        this.append0(ch);
        return this;
    }

    @Override
    public StringBuilder append(CharSequence csq) {
        if (csq == null) {
            this.appendNull();
        } else if (csq instanceof StringBuilder) {
            StringBuilder builder = (StringBuilder)csq;
            this.append0(builder.chars, 0, builder.length);
        } else {
            this.append0(csq.toString());
        }
        return this;
    }

    public StringBuilder append(StringBuilder builder) {
        if (builder == null) {
            this.appendNull();
        } else {
            this.append0(builder.chars, 0, builder.length);
        }
        return this;
    }

    @Override
    public StringBuilder append(CharSequence csq, int start, int end) {
        this.append0(csq, start, end);
        return this;
    }

    public void clear() {
        this.length = 0;
    }

    public StringBuilder replace(char find, String replace) {
        int replaceLength = replace.length();
        int index = 0;
        while (index != this.length) {
            if (this.chars[index] != find) {
                ++index;
                continue;
            }
            this.replace0(index, index + 1, replace);
            index += replaceLength;
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    public int hashCode() {
        int result = 31 + this.length;
        for (int index = 0; index < this.length; ++index) {
            result = 31 * result + this.chars[index];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringBuilder other = (StringBuilder)obj;
        int length = this.length;
        if (length != other.length) {
            return false;
        }
        char[] chars = this.chars;
        char[] chars2 = other.chars;
        for (int i = 0; i < length; ++i) {
            if (chars[i] == chars2[i]) continue;
            return false;
        }
        return true;
    }
}

