/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.vertexeffects;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonRenderer;
import com.esotericsoftware.spine.utils.SpineUtils;

public class SwirlEffect
implements SkeletonRenderer.VertexEffect {
    private float worldX;
    private float worldY;
    private float radius;
    private float angle;
    private Interpolation interpolation = Interpolation.pow2Out;
    private float centerX;
    private float centerY;

    public SwirlEffect(float f) {
        this.radius = f;
    }

    @Override
    public void begin(Skeleton skeleton) {
        this.worldX = skeleton.getX() + this.centerX;
        this.worldY = skeleton.getY() + this.centerY;
    }

    @Override
    public void transform(Vector2 vector2, Vector2 vector22, Color color, Color color2) {
        float f = vector2.x - this.worldX;
        float f2 = vector2.y - this.worldY;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        if (f3 < this.radius) {
            float f4 = this.interpolation.apply(0.0f, this.angle, (this.radius - f3) / this.radius);
            float f5 = SpineUtils.cos(f4);
            float f6 = SpineUtils.sin(f4);
            vector2.x = f5 * f - f6 * f2 + this.worldX;
            vector2.y = f6 * f + f5 * f2 + this.worldY;
        }
    }

    @Override
    public void end() {
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public void setCenter(float f, float f2) {
        this.centerX = f;
        this.centerY = f2;
    }

    public void setCenterX(float f) {
        this.centerX = f;
    }

    public void setCenterY(float f) {
        this.centerY = f;
    }

    public void setAngle(float f) {
        this.angle = f * ((float)Math.PI / 180);
    }

    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(Interpolation interpolation) {
        this.interpolation = interpolation;
    }
}

