/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;

public class TwoColorPolygonBatch {
    private final Mesh mesh;
    private final float[] vertices;
    private final short[] triangles;
    private final Matrix4 transformMatrix = new Matrix4();
    private final Matrix4 projectionMatrix = new Matrix4();
    private final Matrix4 combinedMatrix = new Matrix4();
    private final ShaderProgram defaultShader;
    private ShaderProgram shader;
    private int vertexIndex;
    private int triangleIndex;
    private Texture lastTexture;
    private boolean drawing;
    private int blendSrcFunc = 770;
    private int blendDstFunc = 771;
    private int blendSrcFuncAlpha = 770;
    private int blendDstFuncAlpha = 771;
    private boolean premultipliedAlpha;

    public TwoColorPolygonBatch(int n) {
        this(n, n * 2);
    }

    public TwoColorPolygonBatch(int n, int n2) {
        if (n > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Can't have more than 32767 vertices per batch: " + n2);
        }
        Mesh.VertexDataType vertexDataType = Mesh.VertexDataType.VertexArray;
        if (Gdx.gl30 != null) {
            vertexDataType = Mesh.VertexDataType.VertexBufferObjectWithVAO;
        }
        this.mesh = new Mesh(vertexDataType, false, n, n2 * 3, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_light"), new VertexAttribute(4, 4, "a_dark"), new VertexAttribute(16, 2, "a_texCoord0"));
        this.vertices = new float[n * 6];
        this.triangles = new short[n2 * 3];
        this.shader = this.defaultShader = this.createDefaultShader();
        this.projectionMatrix.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    public void begin() {
        if (this.drawing) {
            throw new IllegalStateException("end must be called before begin.");
        }
        Gdx.gl.glDepthMask(false);
        this.shader.begin();
        this.setupMatrices();
        this.drawing = true;
    }

    public void end() {
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before end.");
        }
        if (this.vertexIndex > 0) {
            this.flush();
        }
        this.shader.end();
        Gdx.gl.glDepthMask(true);
        Gdx.gl.glDisable(3042);
        this.lastTexture = null;
        this.drawing = false;
    }

    public void draw(Texture texture, float[] fArray, int n, int n2, short[] sArray, int n3, int n4) {
        int n5;
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray2 = this.triangles;
        float[] fArray2 = this.vertices;
        if (texture != this.lastTexture) {
            this.flush();
            this.lastTexture = texture;
        } else if (this.triangleIndex + n4 > sArray2.length || this.vertexIndex + n2 > fArray2.length) {
            this.flush();
        }
        int n6 = this.triangleIndex;
        int n7 = this.vertexIndex;
        int n8 = n7 / 6;
        int n9 = n5 + n4;
        for (n5 = n3; n5 < n9; ++n5) {
            sArray2[n6++] = (short)(sArray[n5] + n8);
        }
        this.triangleIndex = n6;
        System.arraycopy(fArray, n, fArray2, n7, n2);
        this.vertexIndex += n2;
    }

    public void flush() {
        if (this.vertexIndex == 0) {
            return;
        }
        this.lastTexture.bind();
        Mesh mesh = this.mesh;
        mesh.setVertices(this.vertices, 0, this.vertexIndex);
        mesh.setIndices(this.triangles, 0, this.triangleIndex);
        Gdx.gl.glEnable(3042);
        if (this.blendSrcFunc != -1) {
            Gdx.gl.glBlendFuncSeparate(this.blendSrcFunc, this.blendDstFunc, this.blendSrcFuncAlpha, this.blendDstFuncAlpha);
        }
        mesh.render(this.shader, 4, 0, this.triangleIndex);
        this.vertexIndex = 0;
        this.triangleIndex = 0;
    }

    public void dispose() {
        this.mesh.dispose();
        this.shader.dispose();
    }

    public Matrix4 getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public Matrix4 getTransformMatrix() {
        return this.transformMatrix;
    }

    public void setProjectionMatrix(Matrix4 matrix4) {
        if (this.drawing) {
            this.flush();
        }
        this.projectionMatrix.set(matrix4);
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    public void setTransformMatrix(Matrix4 matrix4) {
        if (this.drawing) {
            this.flush();
        }
        this.transformMatrix.set(matrix4);
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    public void setPremultipliedAlpha(boolean bl) {
        if (this.premultipliedAlpha == bl) {
            return;
        }
        if (this.drawing) {
            this.flush();
        }
        this.premultipliedAlpha = bl;
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    private void setupMatrices() {
        this.combinedMatrix.set(this.projectionMatrix).mul(this.transformMatrix);
        this.shader.setUniformf("u_pma", this.premultipliedAlpha ? 1.0f : 0.0f);
        this.shader.setUniformMatrix("u_projTrans", this.combinedMatrix);
        this.shader.setUniformi("u_texture", 0);
    }

    public void setShader(ShaderProgram shaderProgram) {
        if (this.shader == shaderProgram) {
            return;
        }
        if (this.drawing) {
            this.flush();
            this.shader.end();
        }
        ShaderProgram shaderProgram2 = this.shader = shaderProgram == null ? this.defaultShader : shaderProgram;
        if (this.drawing) {
            this.shader.begin();
            this.setupMatrices();
        }
    }

    public void setBlendFunction(int n, int n2) {
        this.setBlendFunctionSeparate(n, n2, n, n2);
    }

    public void setBlendFunctionSeparate(int n, int n2, int n3, int n4) {
        if (this.blendSrcFunc == n && this.blendDstFunc == n2 && this.blendSrcFuncAlpha == n3 && this.blendDstFuncAlpha == n4) {
            return;
        }
        this.flush();
        this.blendSrcFunc = n;
        this.blendDstFunc = n2;
        this.blendSrcFuncAlpha = n3;
        this.blendDstFuncAlpha = n4;
    }

    private ShaderProgram createDefaultShader() {
        String string = "attribute vec4 a_position;\nattribute vec4 a_light;\nattribute vec4 a_dark;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_light;\nvarying vec4 v_dark;\nvarying vec2 v_texCoords;\n\nvoid main()\n{\n   v_light = a_light;\n   v_light.a = v_light.a * (255.0/254.0);\n   v_dark = a_dark;\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projTrans * a_position;\n}\n";
        String string2 = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying LOWP vec4 v_light;\nvarying LOWP vec4 v_dark;\nuniform float u_pma;\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nvoid main()\n{\n  vec4 texColor = texture2D(u_texture, v_texCoords);\n  gl_FragColor.a = texColor.a * v_light.a;\n  gl_FragColor.rgb = ((texColor.a - 1.0) * u_pma + 1.0 - texColor.rgb) * v_dark.rgb + texColor.rgb * v_light.rgb;\n}";
        ShaderProgram shaderProgram = new ShaderProgram(string, string2);
        if (!shaderProgram.isCompiled()) {
            throw new IllegalArgumentException("Error compiling shader: " + shaderProgram.getLog());
        }
        return shaderProgram;
    }
}

