/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.RegionAttachment;

public class RegionSequenceAttachment
extends RegionAttachment {
    private Mode mode;
    private float frameTime;
    private TextureRegion[] regions;

    public RegionSequenceAttachment(String string) {
        super(string);
    }

    @Override
    public float[] updateWorldVertices(Slot slot, boolean bl) {
        if (this.regions == null) {
            throw new IllegalStateException("Regions have not been set: " + this);
        }
        int n = (int)(slot.getAttachmentTime() / this.frameTime);
        switch (this.mode) {
            case forward: {
                n = Math.min(this.regions.length - 1, n);
                break;
            }
            case forwardLoop: {
                n %= this.regions.length;
                break;
            }
            case pingPong: {
                if ((n %= this.regions.length << 1) < this.regions.length) break;
                n = this.regions.length - 1 - (n - this.regions.length);
                break;
            }
            case random: {
                n = MathUtils.random(this.regions.length - 1);
                break;
            }
            case backward: {
                n = Math.max(this.regions.length - n - 1, 0);
                break;
            }
            case backwardLoop: {
                n %= this.regions.length;
                n = this.regions.length - n - 1;
            }
        }
        this.setRegion(this.regions[n]);
        return super.updateWorldVertices(slot, bl);
    }

    public TextureRegion[] getRegions() {
        if (this.regions == null) {
            throw new IllegalStateException("Regions have not been set: " + this);
        }
        return this.regions;
    }

    public void setRegions(TextureRegion[] textureRegionArray) {
        this.regions = textureRegionArray;
    }

    public void setFrameTime(float f) {
        this.frameTime = f;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public static enum Mode {
        forward,
        backward,
        forwardLoop,
        backwardLoop,
        pingPong,
        random;

    }
}

