/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonBinary;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonJson;
import com.esotericsoftware.spine.SkeletonMeshRenderer;
import com.esotericsoftware.spine.SkeletonRendererDebug;
import com.esotericsoftware.spine.Skin;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.util.Iterator;

public class SkeletonViewer
extends ApplicationAdapter {
    static final float checkModifiedInterval = 0.25f;
    static final float reloadDelay = 1.0f;
    UI ui;
    PolygonSpriteBatch batch;
    SkeletonMeshRenderer renderer;
    SkeletonRendererDebug debugRenderer;
    SkeletonData skeletonData;
    Skeleton skeleton;
    AnimationState state;
    int skeletonX;
    int skeletonY;
    FileHandle skeletonFile;
    long lastModified;
    float lastModifiedCheck;
    float reloadTimer;
    StringBuilder status = new StringBuilder();
    Preferences prefs;

    @Override
    public void create() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                throwable.printStackTrace();
                Runtime.getRuntime().halt(0);
            }
        });
        this.prefs = Gdx.app.getPreferences("spine-skeletonviewer");
        this.ui = new UI();
        this.batch = new PolygonSpriteBatch();
        this.renderer = new SkeletonMeshRenderer();
        this.debugRenderer = new SkeletonRendererDebug();
        this.skeletonX = (int)(this.ui.window.getWidth() + ((float)Gdx.graphics.getWidth() - this.ui.window.getWidth()) / 2.0f);
        this.skeletonY = Gdx.graphics.getHeight() / 4;
        this.ui.loadPrefs();
        this.loadSkeleton(Gdx.files.internal(Gdx.app.getPreferences("spine-skeletonviewer").getString("lastFile", "spineboy/spineboy.json")));
        this.ui.loadPrefs();
    }

    /*
     * WARNING - void declaration
     */
    void loadSkeleton(final FileHandle fileHandle) {
        Array<String> array;
        if (fileHandle == null) {
            return;
        }
        try {
            Object object;
            void var4_7;
            FileHandle fileHandle2;
            array = new Pixmap(32, 32, Pixmap.Format.RGBA8888);
            ((Pixmap)((Object)array)).setColor(new Color(1.0f, 1.0f, 1.0f, 0.33f));
            ((Pixmap)((Object)array)).fill();
            Iterator<Animation> iterator = new TextureAtlas.AtlasRegion(new Texture((Pixmap)((Object)array)), 0, 0, 32, 32);
            ((Pixmap)((Object)array)).dispose();
            String object2 = fileHandle.nameWithoutExtension();
            if (object2.endsWith(".json")) {
                String string = new FileHandle(object2).nameWithoutExtension();
            }
            if (!(fileHandle2 = fileHandle.sibling((String)var4_7 + ".atlas")).exists()) {
                fileHandle2 = fileHandle.sibling((String)var4_7 + ".atlas.txt");
            }
            TextureAtlas.TextureAtlasData textureAtlasData = !fileHandle2.exists() ? null : new TextureAtlas.TextureAtlasData(fileHandle2, fileHandle2.parent(), false);
            TextureAtlas textureAtlas = new TextureAtlas(textureAtlasData, (TextureAtlas.AtlasRegion)((Object)iterator)){
                final /* synthetic */ TextureAtlas.AtlasRegion val$fake;
                {
                    this.val$fake = atlasRegion;
                    super(textureAtlasData);
                }

                @Override
                public TextureAtlas.AtlasRegion findRegion(String string) {
                    FileHandle fileHandle2;
                    TextureAtlas.AtlasRegion atlasRegion = super.findRegion(string);
                    if (atlasRegion == null && (fileHandle2 = fileHandle.sibling(string + ".png")).exists()) {
                        Texture texture = new Texture(fileHandle2);
                        texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                        atlasRegion = new TextureAtlas.AtlasRegion(texture, 0, 0, texture.getWidth(), texture.getHeight());
                        atlasRegion.name = string;
                    }
                    return atlasRegion != null ? atlasRegion : this.val$fake;
                }
            };
            String string = fileHandle.extension();
            if (string.equalsIgnoreCase("json") || string.equalsIgnoreCase("txt")) {
                object = new SkeletonJson(textureAtlas);
                ((SkeletonJson)object).setScale(this.ui.scaleSlider.getValue());
                this.skeletonData = ((SkeletonJson)object).readSkeletonData(fileHandle);
            } else {
                object = new SkeletonBinary(textureAtlas);
                ((SkeletonBinary)object).setScale(this.ui.scaleSlider.getValue());
                this.skeletonData = ((SkeletonBinary)object).readSkeletonData(fileHandle);
                if (this.skeletonData.getBones().size == 0) {
                    throw new Exception("No bones in skeleton data.");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.ui.toast("Error loading skeleton: " + fileHandle.name());
            this.lastModifiedCheck = 5.0f;
            return;
        }
        this.skeleton = new Skeleton(this.skeletonData);
        this.skeleton.setToSetupPose();
        this.skeleton = new Skeleton(this.skeleton);
        this.skeleton.updateWorldTransform();
        this.state = new AnimationState(new AnimationStateData(this.skeletonData));
        this.state.addListener(new AnimationState.AnimationStateAdapter(){

            @Override
            public void event(AnimationState.TrackEntry trackEntry, Event event) {
                SkeletonViewer.this.ui.toast(event.getData().getName());
            }
        });
        this.skeletonFile = fileHandle;
        this.prefs.putString("lastFile", fileHandle.path());
        this.prefs.flush();
        this.lastModified = fileHandle.lastModified();
        this.lastModifiedCheck = 0.25f;
        this.ui.window.getTitleLabel().setText(fileHandle.name());
        array = new Array();
        for (Skin skin : this.skeletonData.getSkins()) {
            array.add(skin.getName());
        }
        this.ui.skinList.setItems(array);
        array = new Array<String>();
        for (Animation animation : this.skeletonData.getAnimations()) {
            array.add(animation.getName());
        }
        this.ui.animationList.setItems(array);
        this.ui.trackButtons.getButtons().first().setChecked(true);
        if (this.ui.skinList.getSelected() != null) {
            this.skeleton.setSkin(this.ui.skinList.getSelected());
        }
        this.setAnimation();
    }

    void setAnimation() {
        AnimationState.TrackEntry trackEntry;
        if (this.ui.animationList.getSelected() == null) {
            return;
        }
        int n = this.ui.trackButtons.getCheckedIndex();
        AnimationState.TrackEntry trackEntry2 = this.state.getCurrent(n);
        if (trackEntry2 == null) {
            this.state.setEmptyAnimation(n, 0.0f);
            trackEntry = this.state.addAnimation(n, this.ui.animationList.getSelected(), this.ui.loopCheckbox.isChecked(), 0.0f);
            trackEntry.setMixDuration(this.ui.mixSlider.getValue());
        } else {
            trackEntry = this.state.setAnimation(n, this.ui.animationList.getSelected(), this.ui.loopCheckbox.isChecked());
        }
        trackEntry.setAlpha(this.ui.alphaSlider.getValue());
    }

    @Override
    public void render() {
        AnimationState.TrackEntry trackEntry;
        Gdx.gl.glClear(16384);
        float f = Gdx.graphics.getDeltaTime();
        ShapeRenderer shapeRenderer = this.debugRenderer.getShapeRenderer();
        if (this.state != null) {
            shapeRenderer.setColor(Color.DARK_GRAY);
            shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            shapeRenderer.line(this.skeleton.x, -99999.0f, this.skeleton.x, 99999.0f);
            shapeRenderer.line(-99999.0f, this.skeleton.y, 99999.0f, this.skeleton.y);
            shapeRenderer.end();
        }
        if (this.skeleton != null) {
            if (this.reloadTimer <= 0.0f) {
                this.lastModifiedCheck -= f;
                if (this.lastModifiedCheck < 0.0f) {
                    this.lastModifiedCheck = 0.25f;
                    long l = this.skeletonFile.lastModified();
                    if (l != 0L && this.lastModified != l) {
                        this.reloadTimer = 1.0f;
                    }
                }
            } else {
                this.reloadTimer -= f;
                if (this.reloadTimer <= 0.0f) {
                    this.loadSkeleton(this.skeletonFile);
                    this.ui.toast("Reloaded.");
                }
            }
            this.state.getData().setDefaultMix(this.ui.mixSlider.getValue());
            this.renderer.setPremultipliedAlpha(this.ui.premultipliedCheckbox.isChecked());
            this.skeleton.setFlip(this.ui.flipXCheckbox.isChecked(), this.ui.flipYCheckbox.isChecked());
            this.skeleton.setPosition(this.skeletonX, this.skeletonY);
            f = Math.min(f, 0.032f) * this.ui.speedSlider.getValue();
            this.skeleton.update(f);
            this.state.update(f);
            this.state.apply(this.skeleton);
            this.skeleton.updateWorldTransform();
            this.batch.setColor(Color.WHITE);
            this.batch.begin();
            this.renderer.draw(this.batch, this.skeleton);
            this.batch.end();
            this.debugRenderer.setBones(this.ui.debugBonesCheckbox.isChecked());
            this.debugRenderer.setRegionAttachments(this.ui.debugRegionsCheckbox.isChecked());
            this.debugRenderer.setBoundingBoxes(this.ui.debugBoundingBoxesCheckbox.isChecked());
            this.debugRenderer.setMeshHull(this.ui.debugMeshHullCheckbox.isChecked());
            this.debugRenderer.setMeshTriangles(this.ui.debugMeshTrianglesCheckbox.isChecked());
            this.debugRenderer.setPaths(this.ui.debugPathsCheckbox.isChecked());
            this.debugRenderer.draw(this.skeleton);
        }
        if (this.state != null) {
            this.status.setLength(0);
            int n = this.state.getTracks().size;
            for (int i = 0; i < n; ++i) {
                AnimationState.TrackEntry trackEntry2 = this.state.getTracks().get(i);
                if (trackEntry2 == null) continue;
                this.status.append(i);
                this.status.append(": [LIGHT_GRAY]");
                this.status(trackEntry2);
                this.status.append("[WHITE]");
                this.status.append(trackEntry2.animation.name);
                this.status.append('\n');
            }
            this.ui.statusLabel.setText(this.status);
        }
        this.ui.render();
        if (this.state != null && (trackEntry = this.state.getCurrent(0)) != null) {
            shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            float f2 = trackEntry.getAnimationTime() / trackEntry.getAnimationEnd();
            float f3 = this.ui.window.getRight() + ((float)Gdx.graphics.getWidth() - this.ui.window.getRight()) * f2;
            shapeRenderer.setColor(Color.CYAN);
            shapeRenderer.line(f3, 0.0f, f3, 12.0f);
            f2 = trackEntry.getMixDuration() == 0.0f ? 1.0f : Math.min(1.0f, trackEntry.getMixTime() / trackEntry.getMixDuration());
            f3 = this.ui.window.getRight() + ((float)Gdx.graphics.getWidth() - this.ui.window.getRight()) * f2;
            shapeRenderer.setColor(Color.RED);
            shapeRenderer.line(f3, 0.0f, f3, 12.0f);
            shapeRenderer.end();
        }
    }

    void status(AnimationState.TrackEntry trackEntry) {
        AnimationState.TrackEntry trackEntry2 = trackEntry.mixingFrom;
        if (trackEntry2 == null) {
            return;
        }
        this.status(trackEntry2);
        this.status.append(trackEntry2.animation.name);
        this.status.append(' ');
        this.status.append(Math.min(100, (int)(trackEntry.mixTime / trackEntry.mixDuration * 100.0f)));
        this.status.append("% -> ");
    }

    @Override
    public void resize(int n, int n2) {
        this.batch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, n, n2);
        this.debugRenderer.getShapeRenderer().setProjectionMatrix(this.batch.getProjectionMatrix());
        this.ui.stage.getViewport().update(n, n2, true);
        if (!this.ui.minimizeButton.isChecked()) {
            this.ui.window.setHeight(n2 + 8);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        LwjglApplicationConfiguration.disableAudio = true;
        LwjglApplicationConfiguration lwjglApplicationConfiguration = new LwjglApplicationConfiguration();
        lwjglApplicationConfiguration.width = 800;
        lwjglApplicationConfiguration.height = 600;
        lwjglApplicationConfiguration.title = "Skeleton Viewer";
        lwjglApplicationConfiguration.allowSoftwareMode = true;
        new LwjglApplication((ApplicationListener)new SkeletonViewer(), lwjglApplicationConfiguration);
    }

    class UI {
        Stage stage = new Stage(new ScreenViewport());
        com.badlogic.gdx.scenes.scene2d.ui.Skin skin = new com.badlogic.gdx.scenes.scene2d.ui.Skin(Gdx.files.internal("skin/skin.json"));
        Window window = new Window("Skeleton", this.skin);
        Table root = new Table(this.skin);
        TextButton openButton = new TextButton("Open", this.skin);
        List<String> animationList = new List(this.skin);
        ScrollPane animationScroll = new ScrollPane(this.animationList, this.skin, "bg");
        List<String> skinList = new List(this.skin);
        ScrollPane skinScroll = new ScrollPane(this.skinList, this.skin, "bg");
        CheckBox loopCheckbox = new CheckBox("Loop", this.skin);
        CheckBox premultipliedCheckbox = new CheckBox("Premultiplied", this.skin);
        Slider mixSlider = new Slider(0.0f, 4.0f, 0.01f, false, this.skin);
        Label mixLabel = new Label((CharSequence)"0.3", this.skin);
        Slider speedSlider = new Slider(0.0f, 3.0f, 0.01f, false, this.skin);
        Label speedLabel = new Label((CharSequence)"1.0", this.skin);
        CheckBox flipXCheckbox = new CheckBox("X", this.skin);
        CheckBox flipYCheckbox = new CheckBox("Y", this.skin);
        CheckBox debugBonesCheckbox = new CheckBox("Bones", this.skin);
        CheckBox debugRegionsCheckbox = new CheckBox("Regions", this.skin);
        CheckBox debugBoundingBoxesCheckbox = new CheckBox("Bounds", this.skin);
        CheckBox debugMeshHullCheckbox = new CheckBox("Mesh hull", this.skin);
        CheckBox debugMeshTrianglesCheckbox = new CheckBox("Triangles", this.skin);
        CheckBox debugPathsCheckbox = new CheckBox("Paths", this.skin);
        Slider scaleSlider = new Slider(0.1f, 3.0f, 0.01f, false, this.skin);
        Label scaleLabel = new Label((CharSequence)"1.0", this.skin);
        TextButton minimizeButton = new TextButton("-", this.skin);
        TextButton bonesSetupPoseButton = new TextButton("Bones", this.skin);
        TextButton slotsSetupPoseButton = new TextButton("Slots", this.skin);
        TextButton setupPoseButton = new TextButton("Both", this.skin);
        Label statusLabel = new Label((CharSequence)"", this.skin);
        WidgetGroup toasts = new WidgetGroup();
        ButtonGroup<TextButton> trackButtons = new ButtonGroup();
        Slider alphaSlider = new Slider(0.0f, 1.0f, 0.01f, false, this.skin);
        Label alphaLabel = new Label((CharSequence)"1.0", this.skin);
        boolean prefsLoaded;

        UI() {
            this.initialize();
            this.layout();
            this.events();
        }

        void initialize() {
            this.skin.getFont((String)"default").getData().markupEnabled = true;
            for (int i = 0; i < 6; ++i) {
                this.trackButtons.add(new TextButton(i + "", this.skin, "toggle"));
            }
            this.animationList.getSelection().setRequired(false);
            this.premultipliedCheckbox.setChecked(true);
            this.loopCheckbox.setChecked(true);
            this.scaleSlider.setValue(1.0f);
            this.scaleSlider.setSnapToValues(new float[]{1.0f, 1.5f, 2.0f, 2.5f, 3.0f, 3.5f}, 0.01f);
            this.mixSlider.setValue(0.3f);
            this.mixSlider.setSnapToValues(new float[]{1.0f, 1.5f, 2.0f, 2.5f, 3.0f, 3.5f}, 0.1f);
            this.speedSlider.setValue(1.0f);
            this.speedSlider.setSnapToValues(new float[]{0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 2.5f}, 0.1f);
            this.alphaSlider.setValue(1.0f);
            this.alphaSlider.setDisabled(true);
            this.window.setMovable(false);
            this.window.setResizable(false);
            this.window.setKeepWithinStage(false);
            this.window.setX(-3.0f);
            this.window.setY(-2.0f);
            this.window.getTitleLabel().setColor(new Color(0.76f, 1.0f, 1.0f, 1.0f));
            this.window.getTitleTable().add(this.openButton).space(3.0f);
            this.window.getTitleTable().add(this.minimizeButton).width(20.0f);
            this.skinScroll.setFadeScrollBars(false);
            this.animationScroll.setFadeScrollBars(false);
        }

        void layout() {
            this.root.defaults().space(6.0f);
            this.root.columnDefaults(0).top().right().padTop(3.0f);
            this.root.columnDefaults(1).left();
            this.root.add("Scale:");
            Table table = this.table(new Actor[0]);
            table.add(this.scaleLabel).width(29.0f);
            table.add(this.scaleSlider).fillX().expandX();
            this.root.add(table).fill().row();
            this.root.add("Flip:");
            this.root.add(this.table(this.flipXCheckbox, this.flipYCheckbox)).row();
            this.root.add("Debug:");
            this.root.add(this.table(this.debugBonesCheckbox, this.debugRegionsCheckbox, this.debugBoundingBoxesCheckbox)).row();
            this.root.add();
            this.root.add(this.table(this.debugMeshHullCheckbox, this.debugMeshTrianglesCheckbox, this.debugPathsCheckbox)).row();
            this.root.add("Atlas alpha:");
            this.root.add(this.premultipliedCheckbox).row();
            this.root.add(new Image(this.skin.newDrawable("white", new Color(0x4E4E4EFF)))).height(1.0f).fillX().colspan(2).pad(-3.0f, 0.0f, 1.0f, 0.0f).row();
            this.root.add("Setup pose:");
            this.root.add(this.table(this.bonesSetupPoseButton, this.slotsSetupPoseButton, this.setupPoseButton)).row();
            this.root.add("Skin:");
            this.root.add(this.skinScroll).expand().fill().row();
            this.root.add(new Image(this.skin.newDrawable("white", new Color(0x4E4E4EFF)))).height(1.0f).fillX().colspan(2).pad(1.0f, 0.0f, 1.0f, 0.0f).row();
            this.root.add("Track:");
            table = this.table(new Actor[0]);
            for (TextButton textButton : this.trackButtons.getButtons()) {
                table.add(textButton);
            }
            table.add(this.loopCheckbox);
            this.root.add(table).row();
            this.root.add("Entry alpha:");
            table = this.table(new Actor[0]);
            table.add(this.alphaLabel).width(29.0f);
            table.add(this.alphaSlider).fillX().expandX();
            this.root.add(table).fill().row();
            this.root.add("Animation:");
            this.root.add(this.animationScroll).expand().fill().row();
            this.root.add("Default mix:");
            table = this.table(new Actor[0]);
            table.add(this.mixLabel).width(29.0f);
            table.add(this.mixSlider).fillX().expandX();
            this.root.add(table).fill().row();
            this.root.add("Speed:");
            table = this.table(new Actor[0]);
            table.add(this.speedLabel).width(29.0f);
            table.add(this.speedSlider).fillX().expandX();
            this.root.add(table).fill().row();
            this.window.add(this.root).expand().fill();
            this.window.pack();
            this.stage.addActor(this.window);
            this.stage.addActor(this.statusLabel);
            table = new Table();
            table.setFillParent(true);
            table.setTouchable(Touchable.disabled);
            this.stage.addActor(table);
            table.pad(10.0f, 10.0f, 22.0f, 10.0f).bottom().right();
            table.add(this.toasts);
            table = new Table();
            table.setFillParent(true);
            table.setTouchable(Touchable.disabled);
            this.stage.addActor(table);
            table.pad(10.0f).top().right();
            table.defaults().right();
            table.add(new Label((CharSequence)"v3.5.51", this.skin, "default", Color.LIGHT_GRAY));
        }

        void events() {
            this.window.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent inputEvent, float f, float f2, int n, int n2) {
                    inputEvent.cancel();
                    return true;
                }
            });
            this.openButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    FileDialog fileDialog = new FileDialog((Frame)null, "Choose skeleton file");
                    fileDialog.setMode(0);
                    fileDialog.setVisible(true);
                    String string = fileDialog.getFile();
                    String string2 = fileDialog.getDirectory();
                    if (string == null || string2 == null) {
                        return;
                    }
                    SkeletonViewer.this.loadSkeleton(new FileHandle(new File(string2, string).getAbsolutePath()));
                }
            });
            this.setupPoseButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (SkeletonViewer.this.skeleton != null) {
                        SkeletonViewer.this.skeleton.setToSetupPose();
                    }
                }
            });
            this.bonesSetupPoseButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (SkeletonViewer.this.skeleton != null) {
                        SkeletonViewer.this.skeleton.setBonesToSetupPose();
                    }
                }
            });
            this.slotsSetupPoseButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (SkeletonViewer.this.skeleton != null) {
                        SkeletonViewer.this.skeleton.setSlotsToSetupPose();
                    }
                }
            });
            this.minimizeButton.addListener(new ClickListener(){

                @Override
                public boolean touchDown(InputEvent inputEvent, float f, float f2, int n, int n2) {
                    inputEvent.cancel();
                    return super.touchDown(inputEvent, f, f2, n, n2);
                }

                @Override
                public void clicked(InputEvent inputEvent, float f, float f2) {
                    if (UI.this.minimizeButton.isChecked()) {
                        UI.this.window.getCells().get(0).setActor(null);
                        UI.this.window.setHeight(37.0f);
                        UI.this.minimizeButton.setText("+");
                    } else {
                        UI.this.window.getCells().get(0).setActor(UI.this.root);
                        SkeletonViewer.this.ui.window.setHeight(Gdx.graphics.getHeight() + 8);
                        UI.this.minimizeButton.setText("-");
                    }
                }
            });
            this.scaleSlider.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    UI.this.scaleLabel.setText(Float.toString((float)((int)(UI.this.scaleSlider.getValue() * 100.0f)) / 100.0f));
                    if (!UI.this.scaleSlider.isDragging()) {
                        SkeletonViewer.this.loadSkeleton(SkeletonViewer.this.skeletonFile);
                    }
                }
            });
            this.speedSlider.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    UI.this.speedLabel.setText(Float.toString((float)((int)(UI.this.speedSlider.getValue() * 100.0f)) / 100.0f));
                }
            });
            this.alphaSlider.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    AnimationState.TrackEntry trackEntry;
                    UI.this.alphaLabel.setText(Float.toString((float)((int)(UI.this.alphaSlider.getValue() * 100.0f)) / 100.0f));
                    int n = UI.this.trackButtons.getCheckedIndex();
                    if (n > 0 && (trackEntry = SkeletonViewer.this.state.getCurrent(n)) != null) {
                        trackEntry.setAlpha(UI.this.alphaSlider.getValue());
                        trackEntry.resetRotationDirections();
                    }
                }
            });
            this.mixSlider.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    UI.this.mixLabel.setText(Float.toString((float)((int)(UI.this.mixSlider.getValue() * 100.0f)) / 100.0f));
                    if (SkeletonViewer.this.state != null) {
                        SkeletonViewer.this.state.getData().setDefaultMix(UI.this.mixSlider.getValue());
                    }
                }
            });
            this.animationList.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (SkeletonViewer.this.state != null) {
                        String string = UI.this.animationList.getSelected();
                        if (string == null) {
                            SkeletonViewer.this.state.setEmptyAnimation(UI.this.trackButtons.getCheckedIndex(), SkeletonViewer.this.ui.mixSlider.getValue());
                        } else {
                            SkeletonViewer.this.setAnimation();
                        }
                    }
                }
            });
            this.loopCheckbox.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    SkeletonViewer.this.setAnimation();
                }
            });
            this.skinList.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (SkeletonViewer.this.skeleton != null) {
                        String string = UI.this.skinList.getSelected();
                        if (string == null) {
                            SkeletonViewer.this.skeleton.setSkin((Skin)null);
                        } else {
                            SkeletonViewer.this.skeleton.setSkin(string);
                        }
                        SkeletonViewer.this.skeleton.setSlotsToSetupPose();
                    }
                }
            });
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    int n = SkeletonViewer.this.ui.trackButtons.getCheckedIndex();
                    if (n == -1) {
                        return;
                    }
                    AnimationState.TrackEntry trackEntry = SkeletonViewer.this.state.getCurrent(n);
                    UI.this.animationList.getSelection().setProgrammaticChangeEvents(false);
                    UI.this.animationList.setSelected(trackEntry == null ? null : trackEntry.animation.name);
                    UI.this.animationList.getSelection().setProgrammaticChangeEvents(true);
                    UI.this.alphaSlider.setDisabled(n == 0);
                    UI.this.alphaSlider.setValue(trackEntry == null ? 1.0f : trackEntry.alpha);
                }
            };
            for (TextButton textButton : this.trackButtons.getButtons()) {
                textButton.addListener(changeListener);
            }
            Gdx.input.setInputProcessor(new InputMultiplexer(this.stage, new InputAdapter(){
                float offsetX;
                float offsetY;

                @Override
                public boolean touchDown(int n, int n2, int n3, int n4) {
                    this.offsetX = n;
                    this.offsetY = Gdx.graphics.getHeight() - n2;
                    return false;
                }

                @Override
                public boolean touchDragged(int n, int n2, int n3) {
                    float f = (float)n - this.offsetX;
                    float f2 = (float)(Gdx.graphics.getHeight() - n2) - this.offsetY;
                    SkeletonViewer.this.skeletonX = (int)((float)SkeletonViewer.this.skeletonX + f);
                    SkeletonViewer.this.skeletonY = (int)((float)SkeletonViewer.this.skeletonY + f2);
                    this.offsetX = n;
                    this.offsetY = Gdx.graphics.getHeight() - n2;
                    return false;
                }

                @Override
                public boolean touchUp(int n, int n2, int n3, int n4) {
                    UI.this.savePrefs();
                    return false;
                }
            }));
            ChangeListener changeListener2 = new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (actor instanceof Slider && ((Slider)actor).isDragging()) {
                        return;
                    }
                    UI.this.savePrefs();
                }
            };
            this.debugBonesCheckbox.addListener(changeListener2);
            this.debugRegionsCheckbox.addListener(changeListener2);
            this.debugMeshHullCheckbox.addListener(changeListener2);
            this.debugMeshTrianglesCheckbox.addListener(changeListener2);
            this.debugPathsCheckbox.addListener(changeListener2);
            this.premultipliedCheckbox.addListener(changeListener2);
            this.loopCheckbox.addListener(changeListener2);
            this.speedSlider.addListener(changeListener2);
            this.mixSlider.addListener(changeListener2);
            this.scaleSlider.addListener(changeListener2);
            this.animationList.addListener(changeListener2);
            this.skinList.addListener(changeListener2);
        }

        Table table(Actor ... actorArray) {
            Table table = new Table();
            table.defaults().space(6.0f);
            table.add(actorArray);
            return table;
        }

        void render() {
            if (SkeletonViewer.this.state != null && SkeletonViewer.this.state.getCurrent(SkeletonViewer.this.ui.trackButtons.getCheckedIndex()) == null) {
                SkeletonViewer.this.ui.animationList.getSelection().setProgrammaticChangeEvents(false);
                SkeletonViewer.this.ui.animationList.setSelected(null);
                SkeletonViewer.this.ui.animationList.getSelection().setProgrammaticChangeEvents(true);
            }
            this.statusLabel.pack();
            if (this.minimizeButton.isChecked()) {
                this.statusLabel.setPosition(10.0f, 25.0f, 12);
            } else {
                this.statusLabel.setPosition(this.window.getWidth() + 6.0f, 5.0f, 12);
            }
            this.stage.act();
            this.stage.draw();
        }

        void toast(String string) {
            Table table = new Table();
            table.add(new Label((CharSequence)string, this.skin));
            table.getColor().a = 0.0f;
            table.pack();
            table.setPosition(-table.getWidth(), -3.0f - table.getHeight());
            table.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.moveBy(0.0f, table.getHeight(), 0.3f), (Action)Actions.fadeIn(0.3f)), (Action)Actions.delay(5.0f), (Action)Actions.parallel((Action)Actions.moveBy(0.0f, table.getHeight(), 0.3f), (Action)Actions.fadeOut(0.3f)), (Action)Actions.removeActor()));
            for (Actor actor : this.toasts.getChildren()) {
                actor.addAction(Actions.moveBy(0.0f, table.getHeight(), 0.3f));
            }
            this.toasts.addActor(table);
            this.toasts.getParent().toFront();
        }

        void savePrefs() {
            if (!this.prefsLoaded) {
                return;
            }
            SkeletonViewer.this.prefs.putBoolean("debugBones", this.debugBonesCheckbox.isChecked());
            SkeletonViewer.this.prefs.putBoolean("debugRegions", this.debugRegionsCheckbox.isChecked());
            SkeletonViewer.this.prefs.putBoolean("debugMeshHull", this.debugMeshHullCheckbox.isChecked());
            SkeletonViewer.this.prefs.putBoolean("debugMeshTriangles", this.debugMeshTrianglesCheckbox.isChecked());
            SkeletonViewer.this.prefs.putBoolean("debugPaths", this.debugPathsCheckbox.isChecked());
            SkeletonViewer.this.prefs.putBoolean("premultiplied", this.premultipliedCheckbox.isChecked());
            SkeletonViewer.this.prefs.putBoolean("loop", this.loopCheckbox.isChecked());
            SkeletonViewer.this.prefs.putFloat("speed", this.speedSlider.getValue());
            SkeletonViewer.this.prefs.putFloat("mix", this.mixSlider.getValue());
            SkeletonViewer.this.prefs.putFloat("scale", this.scaleSlider.getValue());
            SkeletonViewer.this.prefs.putInteger("x", SkeletonViewer.this.skeletonX);
            SkeletonViewer.this.prefs.putInteger("y", SkeletonViewer.this.skeletonY);
            AnimationState.TrackEntry trackEntry = SkeletonViewer.this.state.getCurrent(0);
            if (trackEntry != null) {
                String string = trackEntry.animation.name;
                if (string.equals("<empty>")) {
                    string = trackEntry.next == null ? "" : trackEntry.next.animation.name;
                }
                SkeletonViewer.this.prefs.putString("animationName", string);
            }
            if (this.skinList.getSelected() != null) {
                SkeletonViewer.this.prefs.putString("skinName", this.skinList.getSelected());
            }
            SkeletonViewer.this.prefs.flush();
        }

        void loadPrefs() {
            try {
                this.debugBonesCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("debugBones", true));
                this.debugRegionsCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("debugRegions", false));
                this.debugMeshHullCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("debugMeshHull", false));
                this.debugMeshTrianglesCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("debugMeshTriangles", false));
                this.debugPathsCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("debugPaths", true));
                this.premultipliedCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("premultiplied", true));
                this.loopCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("loop", false));
                this.speedSlider.setValue(SkeletonViewer.this.prefs.getFloat("speed", 0.3f));
                this.mixSlider.setValue(SkeletonViewer.this.prefs.getFloat("mix", 0.3f));
                this.scaleSlider.setValue(SkeletonViewer.this.prefs.getFloat("scale", 1.0f));
                SkeletonViewer.this.skeletonX = SkeletonViewer.this.prefs.getInteger("x", 0);
                SkeletonViewer.this.skeletonY = SkeletonViewer.this.prefs.getInteger("y", 0);
                this.animationList.setSelected(SkeletonViewer.this.prefs.getString("animationName", null));
                this.skinList.setSelected(SkeletonViewer.this.prefs.getString("skinName", null));
                this.prefsLoaded = true;
            }
            catch (Exception exception) {
                System.out.println("Unable to read preferences:");
                exception.printStackTrace();
            }
        }
    }
}

