/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonBounds;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;

public class SkeletonRendererDebug {
    private static final Color boneLineColor = Color.RED;
    private static final Color boneOriginColor = Color.GREEN;
    private static final Color attachmentLineColor = new Color(0.0f, 0.0f, 1.0f, 0.5f);
    private static final Color triangleLineColor = new Color(1.0f, 0.64f, 0.0f, 0.5f);
    private static final Color aabbColor = new Color(0.0f, 1.0f, 0.0f, 0.5f);
    private final ShapeRenderer shapes;
    private boolean drawBones = true;
    private boolean drawRegionAttachments = true;
    private boolean drawBoundingBoxes = true;
    private boolean drawMeshHull = true;
    private boolean drawMeshTriangles = true;
    private boolean drawPaths = true;
    private final SkeletonBounds bounds = new SkeletonBounds();
    private final FloatArray temp = new FloatArray();
    private float scale = 1.0f;
    private float boneWidth = 2.0f;
    private boolean premultipliedAlpha;

    public SkeletonRendererDebug() {
        this.shapes = new ShapeRenderer();
    }

    public SkeletonRendererDebug(ShapeRenderer shapeRenderer) {
        this.shapes = shapeRenderer;
    }

    public void draw(Skeleton skeleton) {
        short s;
        Object[] objectArray;
        int n;
        int n2;
        Gdx.gl.glEnable(3042);
        int n3 = this.premultipliedAlpha ? 1 : 770;
        Gdx.gl.glBlendFunc(n3, 771);
        ShapeRenderer shapeRenderer = this.shapes;
        Array<Bone> array = skeleton.getBones();
        if (this.drawBones) {
            shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
            n2 = array.size;
            for (n = 0; n < n2; ++n) {
                Bone bone = array.get(n);
                if (bone.parent == null) continue;
                float f = bone.data.length;
                float f2 = this.boneWidth;
                if (f == 0.0f) {
                    f = 8.0f;
                    f2 /= 2.0f;
                    shapeRenderer.setColor(boneOriginColor);
                } else {
                    shapeRenderer.setColor(boneLineColor);
                }
                float f3 = f * bone.a + bone.worldX;
                float f4 = f * bone.c + bone.worldY;
                shapeRenderer.rectLine(bone.worldX, bone.worldY, f3, f4, f2 * this.scale);
            }
            shapeRenderer.end();
            shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            shapeRenderer.x(skeleton.getX(), skeleton.getY(), 4.0f * this.scale);
        } else {
            shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        }
        if (this.drawRegionAttachments) {
            shapeRenderer.setColor(attachmentLineColor);
            Array<Slot> array2 = skeleton.getSlots();
            int n4 = array2.size;
            for (n2 = 0; n2 < n4; ++n2) {
                Slot slot = array2.get(n2);
                Attachment attachment = slot.attachment;
                if (!(attachment instanceof RegionAttachment)) continue;
                RegionAttachment regionAttachment = (RegionAttachment)attachment;
                float[] fArray = regionAttachment.updateWorldVertices(slot, false);
                shapeRenderer.line(fArray[0], fArray[1], fArray[5], fArray[6]);
                shapeRenderer.line(fArray[5], fArray[6], fArray[10], fArray[11]);
                shapeRenderer.line(fArray[10], fArray[11], fArray[15], fArray[16]);
                shapeRenderer.line(fArray[15], fArray[16], fArray[0], fArray[1]);
            }
        }
        if (this.drawMeshHull || this.drawMeshTriangles) {
            Array<Slot> array3 = skeleton.getSlots();
            int n5 = array3.size;
            for (n2 = 0; n2 < n5; ++n2) {
                int n6;
                int n7;
                Slot slot = array3.get(n2);
                Attachment attachment = slot.attachment;
                if (!(attachment instanceof MeshAttachment)) continue;
                MeshAttachment meshAttachment = (MeshAttachment)attachment;
                meshAttachment.updateWorldVertices(slot, false);
                float[] fArray = meshAttachment.getWorldVertices();
                objectArray = meshAttachment.getTriangles();
                int n8 = meshAttachment.getHullLength();
                if (this.drawMeshTriangles) {
                    shapeRenderer.setColor(triangleLineColor);
                    int n9 = objectArray.length;
                    for (int i = 0; i < n9; i += 3) {
                        n7 = objectArray[i] * 5;
                        n6 = objectArray[i + 1] * 5;
                        int n10 = objectArray[i + 2] * 5;
                        shapeRenderer.triangle(fArray[n7], fArray[n7 + 1], fArray[n6], fArray[n6 + 1], fArray[n10], fArray[n10 + 1]);
                    }
                }
                if (!this.drawMeshHull || n8 <= 0) continue;
                shapeRenderer.setColor(attachmentLineColor);
                n8 = (n8 >> 1) * 5;
                float f = fArray[n8 - 5];
                float f5 = fArray[n8 - 4];
                n6 = n8;
                for (n7 = 0; n7 < n6; n7 += 5) {
                    float f6 = fArray[n7];
                    s = (short)fArray[n7 + 1];
                    shapeRenderer.line(f6, s, f, f5);
                    f = f6;
                    f5 = s;
                }
            }
        }
        if (this.drawBoundingBoxes) {
            SkeletonBounds skeletonBounds = this.bounds;
            skeletonBounds.update(skeleton, true);
            shapeRenderer.setColor(aabbColor);
            shapeRenderer.rect(skeletonBounds.getMinX(), skeletonBounds.getMinY(), skeletonBounds.getWidth(), skeletonBounds.getHeight());
            Array<FloatArray> array4 = skeletonBounds.getPolygons();
            Array<BoundingBoxAttachment> array5 = skeletonBounds.getBoundingBoxes();
            int n11 = array4.size;
            for (int i = 0; i < n11; ++i) {
                FloatArray floatArray = array4.get(i);
                shapeRenderer.setColor(array5.get(i).getColor());
                shapeRenderer.polygon(floatArray.items, 0, floatArray.size);
            }
        }
        if (this.drawPaths) {
            Array<Slot> array6 = skeleton.getSlots();
            int n12 = array6.size;
            for (int i = 0; i < n12; ++i) {
                short s2;
                short s3;
                Slot slot = array6.get(i);
                Attachment attachment = slot.attachment;
                if (!(attachment instanceof PathAttachment)) continue;
                PathAttachment pathAttachment = (PathAttachment)attachment;
                int n13 = pathAttachment.getWorldVerticesLength();
                objectArray = this.temp.setSize(n13);
                pathAttachment.computeWorldVertices(slot, (float[])objectArray);
                Color color = pathAttachment.getColor();
                short s4 = objectArray[2];
                short s5 = objectArray[3];
                float f = 0.0f;
                float f7 = 0.0f;
                if (pathAttachment.getClosed()) {
                    shapeRenderer.setColor(color);
                    short s6 = objectArray[0];
                    s = objectArray[1];
                    s3 = objectArray[n13 - 2];
                    s2 = objectArray[n13 - 1];
                    f = objectArray[n13 - 4];
                    f7 = objectArray[n13 - 3];
                    shapeRenderer.curve(s4, s5, s6, s, s3, s2, f, f7, 32);
                    shapeRenderer.setColor(Color.LIGHT_GRAY);
                    shapeRenderer.line(s4, s5, s6, s);
                    shapeRenderer.line(f, f7, s3, s2);
                }
                n13 -= 4;
                for (int j = 4; j < n13; j += 6) {
                    s = objectArray[j];
                    s3 = objectArray[j + 1];
                    s2 = objectArray[j + 2];
                    short s7 = objectArray[j + 3];
                    f = objectArray[j + 4];
                    f7 = objectArray[j + 5];
                    shapeRenderer.setColor(color);
                    shapeRenderer.curve(s4, s5, s, s3, s2, s7, f, f7, 32);
                    shapeRenderer.setColor(Color.LIGHT_GRAY);
                    shapeRenderer.line(s4, s5, s, s3);
                    shapeRenderer.line(f, f7, s2, s7);
                    s4 = (short)f;
                    s5 = (short)f7;
                }
            }
        }
        shapeRenderer.end();
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        if (this.drawBones) {
            shapeRenderer.setColor(boneOriginColor);
            int n14 = array.size;
            for (n = 0; n < n14; ++n) {
                Bone bone = array.get(n);
                shapeRenderer.setColor(Color.GREEN);
                shapeRenderer.circle(bone.worldX, bone.worldY, 3.0f * this.scale, 8);
            }
        }
        shapeRenderer.end();
    }

    public ShapeRenderer getShapeRenderer() {
        return this.shapes;
    }

    public void setBones(boolean bl) {
        this.drawBones = bl;
    }

    public void setScale(float f) {
        this.scale = f;
    }

    public void setRegionAttachments(boolean bl) {
        this.drawRegionAttachments = bl;
    }

    public void setBoundingBoxes(boolean bl) {
        this.drawBoundingBoxes = bl;
    }

    public void setMeshHull(boolean bl) {
        this.drawMeshHull = bl;
    }

    public void setMeshTriangles(boolean bl) {
        this.drawMeshTriangles = bl;
    }

    public void setPaths(boolean bl) {
        this.drawPaths = bl;
    }

    public void setPremultipliedAlpha(boolean bl) {
        this.premultipliedAlpha = bl;
    }
}

