/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DataInput;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.attachments.AtlasAttachmentLoader;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentLoader;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.SkinnedMeshAttachment;
import java.io.IOException;

public class SkeletonBinary {
    public static final int TIMELINE_SCALE = 0;
    public static final int TIMELINE_ROTATE = 1;
    public static final int TIMELINE_TRANSLATE = 2;
    public static final int TIMELINE_ATTACHMENT = 3;
    public static final int TIMELINE_COLOR = 4;
    public static final int TIMELINE_FLIPX = 5;
    public static final int TIMELINE_FLIPY = 6;
    public static final int CURVE_LINEAR = 0;
    public static final int CURVE_STEPPED = 1;
    public static final int CURVE_BEZIER = 2;
    private static final Color tempColor = new Color();
    private final AttachmentLoader attachmentLoader;
    private float scale = 1.0f;

    public SkeletonBinary(TextureAtlas atlas) {
        this.attachmentLoader = new AtlasAttachmentLoader(atlas);
    }

    public SkeletonBinary(AttachmentLoader attachmentLoader) {
        this.attachmentLoader = attachmentLoader;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public SkeletonData readSkeletonData(FileHandle file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        float scale = this.scale;
        SkeletonData skeletonData = new SkeletonData();
        skeletonData.name = file.nameWithoutExtension();
        DataInput input = new DataInput(file.read(512));
        try {
            try {
                skeletonData.hash = input.readString();
                if (skeletonData.hash.isEmpty()) {
                    skeletonData.hash = null;
                }
                skeletonData.version = input.readString();
                if (skeletonData.version.isEmpty()) {
                    skeletonData.version = null;
                }
                skeletonData.width = input.readFloat();
                skeletonData.height = input.readFloat();
                boolean nonessential = input.readBoolean();
                if (nonessential) {
                    skeletonData.imagesPath = input.readString();
                    if (skeletonData.imagesPath.isEmpty()) {
                        skeletonData.imagesPath = null;
                    }
                }
                int i = 0;
                int n = input.readInt(true);
                while (i < n) {
                    String name = input.readString();
                    BoneData parent = null;
                    int parentIndex = input.readInt(true) - 1;
                    if (parentIndex != -1) {
                        parent = skeletonData.bones.get(parentIndex);
                    }
                    BoneData boneData = new BoneData(name, parent);
                    boneData.x = input.readFloat() * scale;
                    boneData.y = input.readFloat() * scale;
                    boneData.scaleX = input.readFloat();
                    boneData.scaleY = input.readFloat();
                    boneData.rotation = input.readFloat();
                    boneData.length = input.readFloat() * scale;
                    boneData.flipX = input.readBoolean();
                    boneData.flipY = input.readBoolean();
                    boneData.inheritScale = input.readBoolean();
                    boneData.inheritRotation = input.readBoolean();
                    if (nonessential) {
                        Color.rgba8888ToColor(boneData.color, input.readInt());
                    }
                    skeletonData.bones.add(boneData);
                    ++i;
                }
                i = 0;
                n = input.readInt(true);
                while (i < n) {
                    IkConstraintData ikConstraintData = new IkConstraintData(input.readString());
                    int ii = 0;
                    int nn = input.readInt(true);
                    while (ii < nn) {
                        ikConstraintData.bones.add(skeletonData.bones.get(input.readInt(true)));
                        ++ii;
                    }
                    ikConstraintData.target = skeletonData.bones.get(input.readInt(true));
                    ikConstraintData.mix = input.readFloat();
                    ikConstraintData.bendDirection = input.readByte();
                    skeletonData.ikConstraints.add(ikConstraintData);
                    ++i;
                }
                i = 0;
                n = input.readInt(true);
                while (i < n) {
                    String slotName = input.readString();
                    BoneData boneData = skeletonData.bones.get(input.readInt(true));
                    SlotData slotData = new SlotData(slotName, boneData);
                    Color.rgba8888ToColor(slotData.color, input.readInt());
                    slotData.attachmentName = input.readString();
                    slotData.additiveBlending = input.readBoolean();
                    skeletonData.slots.add(slotData);
                    ++i;
                }
                Skin defaultSkin = this.readSkin(input, "default", nonessential);
                if (defaultSkin != null) {
                    skeletonData.defaultSkin = defaultSkin;
                    skeletonData.skins.add(defaultSkin);
                }
                int i2 = 0;
                int n2 = input.readInt(true);
                while (i2 < n2) {
                    skeletonData.skins.add(this.readSkin(input, input.readString(), nonessential));
                    ++i2;
                }
                i2 = 0;
                n2 = input.readInt(true);
                while (i2 < n2) {
                    EventData eventData = new EventData(input.readString());
                    eventData.intValue = input.readInt(false);
                    eventData.floatValue = input.readFloat();
                    eventData.stringValue = input.readString();
                    skeletonData.events.add(eventData);
                    ++i2;
                }
                i2 = 0;
                n2 = input.readInt(true);
                while (i2 < n2) {
                    this.readAnimation(input.readString(), input, skeletonData);
                    ++i2;
                }
            }
            catch (IOException ex) {
                throw new SerializationException("Error reading skeleton file.", ex);
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        skeletonData.bones.shrink();
        skeletonData.slots.shrink();
        skeletonData.skins.shrink();
        skeletonData.events.shrink();
        skeletonData.animations.shrink();
        skeletonData.ikConstraints.shrink();
        return skeletonData;
    }

    private Skin readSkin(DataInput input, String skinName, boolean nonessential) throws IOException {
        int slotCount = input.readInt(true);
        if (slotCount == 0) {
            return null;
        }
        Skin skin = new Skin(skinName);
        int i = 0;
        while (i < slotCount) {
            int slotIndex = input.readInt(true);
            int ii = 0;
            int nn = input.readInt(true);
            while (ii < nn) {
                String name = input.readString();
                skin.addAttachment(slotIndex, name, this.readAttachment(input, skin, name, nonessential));
                ++ii;
            }
            ++i;
        }
        return skin;
    }

    private Attachment readAttachment(DataInput input, Skin skin, String attachmentName, boolean nonessential) throws IOException {
        float scale = this.scale;
        String name = input.readString();
        if (name == null) {
            name = attachmentName;
        }
        switch (AttachmentType.values()[input.readByte()]) {
            case region: {
                RegionAttachment region;
                String path = input.readString();
                if (path == null) {
                    path = name;
                }
                if ((region = this.attachmentLoader.newRegionAttachment(skin, name, path)) == null) {
                    return null;
                }
                region.setPath(path);
                region.setX(input.readFloat() * scale);
                region.setY(input.readFloat() * scale);
                region.setScaleX(input.readFloat());
                region.setScaleY(input.readFloat());
                region.setRotation(input.readFloat());
                region.setWidth(input.readFloat() * scale);
                region.setHeight(input.readFloat() * scale);
                Color.rgba8888ToColor(region.getColor(), input.readInt());
                region.updateOffset();
                return region;
            }
            case boundingbox: {
                BoundingBoxAttachment box = this.attachmentLoader.newBoundingBoxAttachment(skin, name);
                if (box == null) {
                    return null;
                }
                box.setVertices(this.readFloatArray(input, scale));
                return box;
            }
            case mesh: {
                MeshAttachment mesh;
                String path = input.readString();
                if (path == null) {
                    path = name;
                }
                if ((mesh = this.attachmentLoader.newMeshAttachment(skin, name, path)) == null) {
                    return null;
                }
                mesh.setPath(path);
                float[] uvs = this.readFloatArray(input, 1.0f);
                short[] triangles = this.readShortArray(input);
                float[] vertices = this.readFloatArray(input, scale);
                mesh.setVertices(vertices);
                mesh.setTriangles(triangles);
                mesh.setRegionUVs(uvs);
                mesh.updateUVs();
                Color.rgba8888ToColor(mesh.getColor(), input.readInt());
                mesh.setHullLength(input.readInt(true) * 2);
                if (nonessential) {
                    mesh.setEdges(this.readIntArray(input));
                    mesh.setWidth(input.readFloat() * scale);
                    mesh.setHeight(input.readFloat() * scale);
                }
                return mesh;
            }
            case skinnedmesh: {
                SkinnedMeshAttachment mesh;
                String path = input.readString();
                if (path == null) {
                    path = name;
                }
                if ((mesh = this.attachmentLoader.newSkinnedMeshAttachment(skin, name, path)) == null) {
                    return null;
                }
                mesh.setPath(path);
                float[] uvs = this.readFloatArray(input, 1.0f);
                short[] triangles = this.readShortArray(input);
                int vertexCount = input.readInt(true);
                FloatArray weights = new FloatArray(uvs.length * 3 * 3);
                IntArray bones = new IntArray(uvs.length * 3);
                int i = 0;
                while (i < vertexCount) {
                    int boneCount = (int)input.readFloat();
                    bones.add(boneCount);
                    int nn = i + boneCount * 4;
                    while (i < nn) {
                        bones.add((int)input.readFloat());
                        weights.add(input.readFloat() * scale);
                        weights.add(input.readFloat() * scale);
                        weights.add(input.readFloat());
                        i += 4;
                    }
                    ++i;
                }
                mesh.setBones(bones.toArray());
                mesh.setWeights(weights.toArray());
                mesh.setTriangles(triangles);
                mesh.setRegionUVs(uvs);
                mesh.updateUVs();
                Color.rgba8888ToColor(mesh.getColor(), input.readInt());
                mesh.setHullLength(input.readInt(true) * 2);
                if (nonessential) {
                    mesh.setEdges(this.readIntArray(input));
                    mesh.setWidth(input.readFloat() * scale);
                    mesh.setHeight(input.readFloat() * scale);
                }
                return mesh;
            }
        }
        return null;
    }

    private float[] readFloatArray(DataInput input, float scale) throws IOException {
        int n = input.readInt(true);
        float[] array = new float[n];
        if (scale == 1.0f) {
            int i = 0;
            while (i < n) {
                array[i] = input.readFloat();
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                array[i] = input.readFloat() * scale;
                ++i;
            }
        }
        return array;
    }

    private short[] readShortArray(DataInput input) throws IOException {
        int n = input.readInt(true);
        short[] array = new short[n];
        int i = 0;
        while (i < n) {
            array[i] = input.readShort();
            ++i;
        }
        return array;
    }

    private int[] readIntArray(DataInput input) throws IOException {
        int n = input.readInt(true);
        int[] array = new int[n];
        int i = 0;
        while (i < n) {
            array[i] = input.readInt(true);
            ++i;
        }
        return array;
    }

    private void readAnimation(String name, DataInput input, SkeletonData skeletonData) {
        Array<Animation.Timeline> timelines = new Array<Animation.Timeline>();
        float scale = this.scale;
        float duration = 0.0f;
        try {
            int eventCount;
            int i;
            Animation.Timeline timeline;
            int frameCount;
            byte timelineType;
            int nn;
            int ii;
            int i2 = 0;
            int n = input.readInt(true);
            while (i2 < n) {
                int slotIndex = input.readInt(true);
                ii = 0;
                nn = input.readInt(true);
                while (ii < nn) {
                    timelineType = input.readByte();
                    frameCount = input.readInt(true);
                    switch (timelineType) {
                        case 4: {
                            timeline = new Animation.ColorTimeline(frameCount);
                            ((Animation.ColorTimeline)timeline).slotIndex = slotIndex;
                            int frameIndex = 0;
                            while (frameIndex < frameCount) {
                                float time = input.readFloat();
                                Color.rgba8888ToColor(tempColor, input.readInt());
                                ((Animation.ColorTimeline)timeline).setFrame(frameIndex, time, SkeletonBinary.tempColor.r, SkeletonBinary.tempColor.g, SkeletonBinary.tempColor.b, SkeletonBinary.tempColor.a);
                                if (frameIndex < frameCount - 1) {
                                    this.readCurve(input, frameIndex, (Animation.CurveTimeline)timeline);
                                }
                                ++frameIndex;
                            }
                            timelines.add(timeline);
                            duration = Math.max(duration, ((Animation.ColorTimeline)timeline).getFrames()[frameCount * 5 - 5]);
                            break;
                        }
                        case 3: {
                            timeline = new Animation.AttachmentTimeline(frameCount);
                            ((Animation.AttachmentTimeline)timeline).slotIndex = slotIndex;
                            int frameIndex = 0;
                            while (frameIndex < frameCount) {
                                ((Animation.AttachmentTimeline)timeline).setFrame(frameIndex, input.readFloat(), input.readString());
                                ++frameIndex;
                            }
                            timelines.add(timeline);
                            duration = Math.max(duration, ((Animation.AttachmentTimeline)timeline).getFrames()[frameCount - 1]);
                        }
                    }
                    ++ii;
                }
                ++i2;
            }
            i2 = 0;
            n = input.readInt(true);
            while (i2 < n) {
                int boneIndex = input.readInt(true);
                ii = 0;
                nn = input.readInt(true);
                while (ii < nn) {
                    timelineType = input.readByte();
                    frameCount = input.readInt(true);
                    switch (timelineType) {
                        case 1: {
                            timeline = new Animation.RotateTimeline(frameCount);
                            ((Animation.RotateTimeline)timeline).boneIndex = boneIndex;
                            int frameIndex = 0;
                            while (frameIndex < frameCount) {
                                ((Animation.RotateTimeline)timeline).setFrame(frameIndex, input.readFloat(), input.readFloat());
                                if (frameIndex < frameCount - 1) {
                                    this.readCurve(input, frameIndex, (Animation.CurveTimeline)timeline);
                                }
                                ++frameIndex;
                            }
                            timelines.add(timeline);
                            duration = Math.max(duration, ((Animation.RotateTimeline)timeline).getFrames()[frameCount * 2 - 2]);
                            break;
                        }
                        case 0: 
                        case 2: {
                            float timelineScale = 1.0f;
                            if (timelineType == 0) {
                                timeline = new Animation.ScaleTimeline(frameCount);
                            } else {
                                timeline = new Animation.TranslateTimeline(frameCount);
                                timelineScale = scale;
                            }
                            ((Animation.TranslateTimeline)timeline).boneIndex = boneIndex;
                            int frameIndex = 0;
                            while (frameIndex < frameCount) {
                                ((Animation.TranslateTimeline)timeline).setFrame(frameIndex, input.readFloat(), input.readFloat() * timelineScale, input.readFloat() * timelineScale);
                                if (frameIndex < frameCount - 1) {
                                    this.readCurve(input, frameIndex, (Animation.CurveTimeline)timeline);
                                }
                                ++frameIndex;
                            }
                            timelines.add(timeline);
                            duration = Math.max(duration, ((Animation.TranslateTimeline)timeline).getFrames()[frameCount * 3 - 3]);
                            break;
                        }
                        case 5: 
                        case 6: {
                            timeline = timelineType == 5 ? new Animation.FlipXTimeline(frameCount) : new Animation.FlipYTimeline(frameCount);
                            ((Animation.FlipXTimeline)timeline).boneIndex = boneIndex;
                            int frameIndex = 0;
                            while (frameIndex < frameCount) {
                                ((Animation.FlipXTimeline)timeline).setFrame(frameIndex, input.readFloat(), input.readBoolean());
                                ++frameIndex;
                            }
                            timelines.add(timeline);
                            duration = Math.max(duration, ((Animation.FlipXTimeline)timeline).getFrames()[frameCount * 2 - 2]);
                        }
                    }
                    ++ii;
                }
                ++i2;
            }
            i2 = 0;
            n = input.readInt(true);
            while (i2 < n) {
                IkConstraintData ikConstraint = skeletonData.ikConstraints.get(input.readInt(true));
                int frameCount2 = input.readInt(true);
                Animation.IkConstraintTimeline timeline2 = new Animation.IkConstraintTimeline(frameCount2);
                timeline2.ikConstraintIndex = skeletonData.getIkConstraints().indexOf(ikConstraint, true);
                int frameIndex = 0;
                while (frameIndex < frameCount2) {
                    timeline2.setFrame(frameIndex, input.readFloat(), input.readFloat(), input.readByte());
                    if (frameIndex < frameCount2 - 1) {
                        this.readCurve(input, frameIndex, timeline2);
                    }
                    ++frameIndex;
                }
                timelines.add(timeline2);
                duration = Math.max(duration, timeline2.getFrames()[frameCount2 * 3 - 3]);
                ++i2;
            }
            i2 = 0;
            n = input.readInt(true);
            while (i2 < n) {
                Skin skin = skeletonData.skins.get(input.readInt(true));
                ii = 0;
                int nn2 = input.readInt(true);
                while (ii < nn2) {
                    int slotIndex = input.readInt(true);
                    int iii = 0;
                    int nnn = input.readInt(true);
                    while (iii < nnn) {
                        Attachment attachment = skin.getAttachment(slotIndex, input.readString());
                        int frameCount3 = input.readInt(true);
                        Animation.FfdTimeline timeline3 = new Animation.FfdTimeline(frameCount3);
                        timeline3.slotIndex = slotIndex;
                        timeline3.attachment = attachment;
                        int frameIndex = 0;
                        while (frameIndex < frameCount3) {
                            float[] vertices;
                            float time = input.readFloat();
                            int vertexCount = attachment instanceof MeshAttachment ? ((MeshAttachment)attachment).getVertices().length : ((SkinnedMeshAttachment)attachment).getWeights().length / 3 * 2;
                            int end = input.readInt(true);
                            if (end == 0) {
                                vertices = attachment instanceof MeshAttachment ? ((MeshAttachment)attachment).getVertices() : new float[vertexCount];
                            } else {
                                int v;
                                vertices = new float[vertexCount];
                                int start = input.readInt(true);
                                end += start;
                                if (scale == 1.0f) {
                                    v = start;
                                    while (v < end) {
                                        vertices[v] = input.readFloat();
                                        ++v;
                                    }
                                } else {
                                    v = start;
                                    while (v < end) {
                                        vertices[v] = input.readFloat() * scale;
                                        ++v;
                                    }
                                }
                                if (attachment instanceof MeshAttachment) {
                                    float[] meshVertices = ((MeshAttachment)attachment).getVertices();
                                    int v2 = 0;
                                    int vn = vertices.length;
                                    while (v2 < vn) {
                                        int n2 = v2;
                                        vertices[n2] = vertices[n2] + meshVertices[v2];
                                        ++v2;
                                    }
                                }
                            }
                            timeline3.setFrame(frameIndex, time, vertices);
                            if (frameIndex < frameCount3 - 1) {
                                this.readCurve(input, frameIndex, timeline3);
                            }
                            ++frameIndex;
                        }
                        timelines.add(timeline3);
                        duration = Math.max(duration, timeline3.getFrames()[frameCount3 - 1]);
                        ++iii;
                    }
                    ++ii;
                }
                ++i2;
            }
            int drawOrderCount = input.readInt(true);
            if (drawOrderCount > 0) {
                Animation.DrawOrderTimeline timeline4 = new Animation.DrawOrderTimeline(drawOrderCount);
                int slotCount = skeletonData.slots.size;
                i = 0;
                while (i < drawOrderCount) {
                    int offsetCount = input.readInt(true);
                    int[] drawOrder = new int[slotCount];
                    int ii2 = slotCount - 1;
                    while (ii2 >= 0) {
                        drawOrder[ii2] = -1;
                        --ii2;
                    }
                    int[] unchanged = new int[slotCount - offsetCount];
                    int originalIndex = 0;
                    int unchangedIndex = 0;
                    int ii3 = 0;
                    while (ii3 < offsetCount) {
                        int slotIndex = input.readInt(true);
                        while (originalIndex != slotIndex) {
                            unchanged[unchangedIndex++] = originalIndex++;
                        }
                        drawOrder[originalIndex + input.readInt((boolean)true)] = originalIndex++;
                        ++ii3;
                    }
                    while (originalIndex < slotCount) {
                        unchanged[unchangedIndex++] = originalIndex++;
                    }
                    ii3 = slotCount - 1;
                    while (ii3 >= 0) {
                        if (drawOrder[ii3] == -1) {
                            drawOrder[ii3] = unchanged[--unchangedIndex];
                        }
                        --ii3;
                    }
                    timeline4.setFrame(i, input.readFloat(), drawOrder);
                    ++i;
                }
                timelines.add(timeline4);
                duration = Math.max(duration, timeline4.getFrames()[drawOrderCount - 1]);
            }
            if ((eventCount = input.readInt(true)) > 0) {
                Animation.EventTimeline timeline5 = new Animation.EventTimeline(eventCount);
                i = 0;
                while (i < eventCount) {
                    float time = input.readFloat();
                    EventData eventData = skeletonData.events.get(input.readInt(true));
                    Event event = new Event(eventData);
                    event.intValue = input.readInt(false);
                    event.floatValue = input.readFloat();
                    event.stringValue = input.readBoolean() ? input.readString() : eventData.stringValue;
                    timeline5.setFrame(i, time, event);
                    ++i;
                }
                timelines.add(timeline5);
                duration = Math.max(duration, timeline5.getFrames()[eventCount - 1]);
            }
        }
        catch (IOException ex) {
            throw new SerializationException("Error reading skeleton file.", ex);
        }
        timelines.shrink();
        skeletonData.animations.add(new Animation(name, timelines, duration));
    }

    private void readCurve(DataInput input, int frameIndex, Animation.CurveTimeline timeline) throws IOException {
        switch (input.readByte()) {
            case 1: {
                timeline.setStepped(frameIndex);
                break;
            }
            case 2: {
                this.setCurve(timeline, frameIndex, input.readFloat(), input.readFloat(), input.readFloat(), input.readFloat());
            }
        }
    }

    void setCurve(Animation.CurveTimeline timeline, int frameIndex, float cx1, float cy1, float cx2, float cy2) {
        timeline.setCurve(frameIndex, cx1, cy1, cx2, cy2);
    }
}

